--------------------------------------------------------------------------------
--
-- Behavorial simulation model for Viterbi decoder
--
-- File name    : viterbi.vhd
--
-- Version      : 6.1
-- 
--  Copyright(C) 2005 by Xilinx, inc. all rights reserved.
--  This text/file contains proprietary, confidential
--  information of Xilinx, inc., is distributed under license
--  from Xilinx, inc., and may be used, copied and/or
--  disclosed only pursuant to the terms of a valid license
--  agreement with Xilinx, inc.  Xilinx hereby grants you
--  a license to use this text/file solely for design, simulation,
--  implementation and creation of design files limited
--  to Xilinx devices or technologies. use with non-Xilinx
--  devices or technologies is expressly prohibited and
--  immediately terminates your license unless covered by
--  a separate agreement.
--
--  Xilinx is providing this design, code, or information
--  "as is" solely for use in developing programs and
--  solutions for Xilinx devices.  By providing this design,
--  code, or information as one possible implementation of
--  this feature, application or standard, Xilinx is making no
--  representation that this implementation is free from any
--  claims of infringement.  You are responsible for
--  obtaining any rights you may require for your implementation.
--  Xilinx expressly disclaims any warranty whatsoever with
--  respect to the adequacy of the implementation, including
--  but not limited to any warranties or representations that this
--  implementation is free from claims of infringement, implied
--  warranties of merchantability or fitness for a particular
--  purpose.
--
--  Xilinx products are not intended for use in life support
--  appliances, devices, or systems. use in such applications are
--  expressly prohibited.
--
--  This copyright and support notice must be retained as part
--  of this text at all times. (c) Copyright 1995-2005 Xilinx, inc.
--  all rights reserved.
--------------------------------------------------------------------------------
--
-- $RCSfile: convolution_unobf_v6_1.vhd,v $

LIBRARY IEEE;USE IEEE.STD_LOGIC_1164.ALL;LIBRARY XILINXCORELIB;USE XILINXCORELIB.PRIMS_CONSTANTS_V9_0.ALL;PACKAGE
 CONVOLUTION_PACK_V6_1 IS CONSTANT II1IOOO1II0l1lOl00I1O001I00O0IIIII:STRING(1 TO 1):=(1=>LF);CONSTANT IO1lll0I0l0l1ll1O01Ol0III011IOIIII:INTEGER:=7;CONSTANT
 IOO0111OO0lOOl10l1l000l0OlI0IIIIII:INTEGER:=9;CONSTANT IIlO1lIIlOlOOO0l10OI1ll0I0O10IIIII:INTEGER:=16;CONSTANT IOOOlI0llOIl11IO01100OI1llOIIOIIII:INTEGER:=3;CONSTANT
 IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII:INTEGER:=3;CONSTANT II1001IO0010Oll1I01lOI0I0IlIOIIIII:INTEGER:=0;CONSTANT IO110I1O0010OIOlIO00l1IIOl0llIIIII:INTEGER:=3;CONSTANT
 IIIOOIO01011011IOIIlllIIOO0l1IIIII:INTEGER:=4;CONSTANT II1IOOO00I0OI0O01I000O100llOOIIIII:INTEGER:=5;CONSTANT II00OI0110lI1II101lO1OO00I10OIIIII:INTEGER:=7;
CONSTANT II00OIlIlO101I0IIOO0O1I0ll0OIIIIII:INTEGER:=7;CONSTANT IOOI1l1OO01O111lO010OlO1O0l0IIIIII:INTEGER:=7;CONSTANT IO11OllII1lO110Ol0I0O00I01l00IIIII:
INTEGER:=7;CONSTANT III01lO1l00IOOO0O0I0O0I111O0IIIIII:INTEGER:=7;CONSTANT IO1I1l01l1OI111Ol0IO10110I11IOIIII:INTEGER:=7;CONSTANT
 IOOll1I1OOlO0lOO0IIII1lO11IIlIIIII:INTEGER:=0;CONSTANT IIIOI11O0OO00OllOllO00lOI000IOIIII:INTEGER:=0;CONSTANT IIOIOOO11l0lO001OI10I0IIIIlIIIIIII:INTEGER:=0;CONSTANT
 II0IO0I0Olll01OOO0lIOO01lOlIOOIIII:INTEGER:=0;CONSTANT IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII:INTEGER:=0;CONSTANT II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII:INTEGER:=0;CONSTANT IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII:INTEGER
:=0;CONSTANT IO0O10O101OOIOOl10lIIO101lIIIIIIII:INTEGER:=1;CONSTANT IIOl10001I1Ol001OIO01IO1II10OIIIII:INTEGER:=0;CONSTANT IIIO0lOII1OIlOOIO1IlI1lIIO001IIIII:INTEGER:=0;CONSTANT
 IIIIl1100lOI0I1OO1I00OlI0l10IIIIII:INTEGER:=0;TYPE IOlI00I100IOOOl011O11IOI1l010IIIII IS ARRAY(0 TO IO1lll0I0l0l1ll1O01Ol0III011IOIIII-1)OF INTEGER;TYPE IIIO1O1110Oll10OI110OIIO111OOIIIII IS ARRAY(0 TO 1
)OF INTEGER;FUNCTION IIl0OIlO00I0lI101l1I0lO1II0IlIIIII(IOIlII1I0O0l1l1O110O0IOlO0O1lIIIII,II11I0011I0IIIl0100l1O01O01O0IIIII:INTEGER)RETURN INTEGER;FUNCTION II011lO0O1l10O0I0OIOO000I0O1IOIIII(IO1IIIl1OO00II0ll110l0l0IIO0lIIIII:INTEGER)RETURN INTEGER;FUNCTION
 IIlOllOOI0ll11O1101IIl0l11ll1IIIII(II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII,III1OO10l11110IO1IO0lOII0OO11IIIII:INTEGER)RETURN STD_LOGIC_VECTOR;FUNCTION IO1O1llOO0IlllI1O1OlOI010l1IIIIIII(IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII:STD_LOGIC_VECTOR)RETURN
 STD_LOGIC_VECTOR;FUNCTION II1IO01lI1IO1OII11O1II01I0llIOIIII(II1lIII001001Il0l0OOl0I00I01IIIIII,II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII:INTEGER)RETURN INTEGER;FUNCTION IOII100I0I1l010IOI1lO1O1I1101IIIII(IOO10OI11Il110I11IIIIIOIO10OlIIIII:INTEGER)
RETURN STRING;FUNCTION IOO1I1lI11Ol1l1OOlllIIII1l1IOIIIII(IOl0l10lI11IO10lI1OI1IOI01OO0IIIII:STRING;IOO1l1010O10O10I0llO11O100O1IOIIII,IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII:INTEGER)RETURN INTEGER;FUNCTION II0IOOI1Il101lO1O010O0O0IO10IOIIII(IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII:STRING
;IOOIOOI00l1OOOlI1OOO0I00Ol0IlIIIII:INTEGER)RETURN INTEGER;END;PACKAGE BODY CONVOLUTION_PACK_V6_1 IS FUNCTION IIl0OIlO00I0lI101l1I0lO1II0IlIIIII(IOIlII1I0O0l1l1O110O0IOlO0O1lIIIII,II11I0011I0IIIl0100l1O01O01O0IIIII:INTEGER)RETURN INTEGER
 IS VARIABLE II111OIOII1IIOOOlO1I011OI0I0lIIIII,III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII:INTEGER;BEGIN II111OIOII1IIOOOlO1I011OI0I0lIIIII:=0;III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII:=IOIlII1I0O0l1l1O110O0IOlO0O1lIIIII;FOR IIIIlI10IO0IlIll11O0O1OII0OIIOIIII IN 0 TO II11I0011I0IIIl0100l1O01O01O0IIIII-1 LOOP IF(III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII
 REM 2)=1 THEN II111OIOII1IIOOOlO1I011OI0I0lIIIII:=II111OIOII1IIOOOlO1I011OI0I0lIIIII+1;END IF;III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII:=III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII/2;END LOOP;RETURN II111OIOII1IIOOOlO1I011OI0I0lIIIII;END;FUNCTION II011lO0O1l10O0I0OIOO000I0O1IOIIII(IO1IIIl1OO00II0ll110l0l0IIO0lIIIII:
INTEGER)RETURN INTEGER IS VARIABLE IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII:INTEGER;VARIABLE IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII:INTEGER:=IO1IIIl1OO00II0ll110l0l0IIO0lIIIII;BEGIN IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII:=0;FOR IIl1O1I0001l1001OllOOII0I10l1IIIII IN 0 TO 32-1 LOOP IF((IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII MOD
 2)=1)THEN IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII:=IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII+1;END IF;IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII:=IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII/2;IF(IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII=0)THEN EXIT;END IF;END LOOP;RETURN IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII;END;FUNCTION
 IIlOllOOI0ll11O1101IIl0l11ll1IIIII(II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII,III1OO10l11110IO1IO0lOII0OO11IIIII:INTEGER)RETURN STD_LOGIC_VECTOR IS VARIABLE IIlIlll0III10I0Il0I0OOOIOIIOOIIIII:INTEGER:=II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII;VARIABLE
 IOOI10l0O1lIlIll00Ol1lll10IIIIIIII:STD_LOGIC_VECTOR(III1OO10l11110IO1IO0lOII0OO11IIIII-1 DOWNTO 0);BEGIN IF(II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII<0)THEN IIlIlll0III10I0Il0I0OOOIOIIOOIIIII:=-1*II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII;END IF;FOR IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII IN 0 TO III1OO10l11110IO1IO0lOII0OO11IIIII-1
 LOOP IF IIlIlll0III10I0Il0I0OOOIOIIOOIIIII MOD 2=0 THEN IOOI10l0O1lIlIll00Ol1lll10IIIIIIII(IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII):='0';ELSE IOOI10l0O1lIlIll00Ol1lll10IIIIIIII(IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII):='1';END IF;IIlIlll0III10I0Il0I0OOOIOIIOOIIIII:=IIlIlll0III10I0Il0I0OOOIOIIOOIIIII/2;END
 LOOP;IF(II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII<0)THEN RETURN IO1O1llOO0IlllI1O1OlOI010l1IIIIIII(IOOI10l0O1lIlIll00Ol1lll10IIIIIIII);ELSE RETURN IOOI10l0O1lIlIll00Ol1lll10IIIIIIII;END IF;END;FUNCTION IO1O1llOO0IlllI1O1OlOI010l1IIIIIII(IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII:STD_LOGIC_VECTOR
)RETURN STD_LOGIC_VECTOR IS VARIABLE IOl0I10010lIIIl000I1O1IO1IlOIIIIII:STD_LOGIC_VECTOR(IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII'HIGH DOWNTO 0);VARIABLE IOl1I1O0IIO001llOlll1I1lOI1l0IIIII:INTEGER:=0;BEGIN FOR IOl1Ol11IlIl0110l0OOll000lI11IIIII IN 0 TO
 IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII'HIGH LOOP IF(IOl1I1O0IIO001llOlll1I1lOI1l0IIIII=1)THEN IF(IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII(IOl1Ol11IlIl0110l0OOll000lI11IIIII)='0')THEN IOl0I10010lIIIl000I1O1IO1IlOIIIIII(IOl1Ol11IlIl0110l0OOll000lI11IIIII):='1';ELSE IOl0I10010lIIIl000I1O1IO1IlOIIIIII(IOl1Ol11IlIl0110l0OOll000lI11IIIII):='0';END IF;ELSE IOl0I10010lIIIl000I1O1IO1IlOIIIIII(IOl1Ol11IlIl0110l0OOll000lI11IIIII):=IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII(IOl1Ol11IlIl0110l0OOll000lI11IIIII);
IF(IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII(IOl1Ol11IlIl0110l0OOll000lI11IIIII)='1')THEN IOl1I1O0IIO001llOlll1I1lOI1l0IIIII:=1;END IF;END IF;END LOOP;RETURN IOl0I10010lIIIl000I1O1IO1IlOIIIIII;END;FUNCTION II1IO01lI1IO1OII11O1II01I0llIOIIII(II1lIII001001Il0l0OOl0I00I01IIIIII,II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII:INTEGER)
RETURN INTEGER IS VARIABLE II001Il0III1O1OI001IOI100000OIIIII:INTEGER:=0;BEGIN IF(II1lIII001001Il0l0OOl0I00I01IIIIII=0)THEN II001Il0III1O1OI001IOI100000OIIIII:=1;ELSE IF(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII=0)THEN II001Il0III1O1OI001IOI100000OIIIII:=3;ELSE
 II001Il0III1O1OI001IOI100000OIIIII:=1;END IF;END IF;RETURN II001Il0III1O1OI001IOI100000OIIIII;END;FUNCTION IOII100I0I1l010IOI1lO1O1I1101IIIII(IOO10OI11Il110I11IIIIIOIO10OlIIIII:INTEGER)RETURN STRING IS VARIABLE IOOl0llO0OI110111OIOlOIO0lOOIOIIII:INTEGER;
VARIABLE II1IOO1l1I11I1ll1OI1I00lII000IIIII:INTEGER;VARIABLE II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII:INTEGER:=0;VARIABLE IOOl0IOOO1011llOIOl01lIOI0O11IIIII:INTEGER;VARIABLE IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII:INTEGER;CONSTANT II1I0O0100lIIII11lI00l0OOII0lIIIII:STRING(1 TO 10):=
"0123456789";VARIABLE IIOIOI0lO1lO100O11Il0OII11OlOIIIII:STRING(1 TO 11);BEGIN IF IOO10OI11Il110I11IIIIIOIO10OlIIIII<0 THEN IF IOO10OI11Il110I11IIIIIOIO10OlIIIII<-2147483647 THEN RETURN(
"less than VHDL minimum INTEGER value");ELSE II1IOO1l1I11I1ll1OI1I00lII000IIIII:=-1*IOO10OI11Il110I11IIIIIOIO10OlIIIII;IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII:=1;IIOIOI0lO1lO100O11Il0OII11OlOIIIII(1):='-';END IF;ELSE II1IOO1l1I11I1ll1OI1I00lII000IIIII:=IOO10OI11Il110I11IIIIIOIO10OlIIIII;
IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII:=0;END IF;IF(II1IOO1l1I11I1ll1OI1I00lII000IIIII=0)THEN RETURN"0";ELSIF(II1IOO1l1I11I1ll1OI1I00lII000IIIII<10)THEN II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII:=1+IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII;ELSIF(II1IOO1l1I11I1ll1OI1I00lII000IIIII<100)THEN II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII:=2+
IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII;ELSIF(II1IOO1l1I11I1ll1OI1I00lII000IIIII<1000)THEN II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII:=3+IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII;ELSIF(II1IOO1l1I11I1ll1OI1I00lII000IIIII<10000)THEN II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII:=4+IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII;ELSIF(II1IOO1l1I11I1ll1OI1I00lII000IIIII<100000)THEN
 II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII:=5+IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII;ELSIF(II1IOO1l1I11I1ll1OI1I00lII000IIIII<1000000)THEN II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII:=6+IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII;ELSIF(II1IOO1l1I11I1ll1OI1I00lII000IIIII<10000000)THEN II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII:=7+IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII;ELSIF(II1IOO1l1I11I1ll1OI1I00lII000IIIII
<100000000)THEN II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII:=8+IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII;ELSIF(II1IOO1l1I11I1ll1OI1I00lII000IIIII<1000000000)THEN II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII:=9+IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII;ELSE II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII:=10+IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII;END IF;IF(
II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII>0)THEN IOOl0IOOO1011llOIOl01lIOI0O11IIIII:=II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII;WHILE(II1IOO1l1I11I1ll1OI1I00lII000IIIII/=0)LOOP IOOl0llO0OI110111OIOlOIO0lOOIOIIII:=II1IOO1l1I11I1ll1OI1I00lII000IIIII MOD 10;IIOIOI0lO1lO100O11Il0OII11OlOIIIII(IOOl0IOOO1011llOIOl01lIOI0O11IIIII):=II1I0O0100lIIII11lI00l0OOII0lIIIII(IOOl0llO0OI110111OIOlOIO0lOOIOIIII+1);II1IOO1l1I11I1ll1OI1I00lII000IIIII:=II1IOO1l1I11I1ll1OI1I00lII000IIIII/10;IOOl0IOOO1011llOIOl01lIOI0O11IIIII:=IOOl0IOOO1011llOIOl01lIOI0O11IIIII-1;END
 LOOP;END IF;RETURN IIOIOI0lO1lO100O11Il0OII11OlOIIIII(1 TO II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII);END;FUNCTION IOO1I1lI11Ol1l1OOlllIIII1l1IOIIIII(IOl0l10lI11IO10lI1OI1IOI01OO0IIIII:STRING;IOO1l1010O10O10I0llO11O100O1IOIIII,IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII:INTEGER)RETURN INTEGER IS BEGIN
 IF IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII/=0 THEN ASSERT FALSE REPORT IOl0l10lI11IO10lI1OI1IOI01OO0IIIII&IOII100I0I1l010IOI1lO1O1I1101IIIII(IOO1l1010O10O10I0llO11O100O1IOIIII)&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY NOTE;END IF;RETURN 1;END;FUNCTION
 II0IOOI1Il101lO1O010O0O0IO10IOIIII(IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII:STRING;IOOIOOI00l1OOOlI1OOO0I00Ol0IlIIIII:INTEGER)RETURN INTEGER IS BEGIN IF IOOIOOI00l1OOOlI1OOO0I00Ol0IlIIIII/=0 THEN ASSERT FALSE REPORT II1IOOO1II0l1lOl00I1O001I00O0IIIII&IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII
 SEVERITY NOTE;END IF;RETURN 1;END;END;LIBRARY IEEE;USE IEEE.STD_LOGIC_1164.ALL;LIBRARY STD;USE STD.TEXTIO.ALL;LIBRARY XILINXCORELIB
;USE XILINXCORELIB.PRIMS_CONSTANTS_V9_0.ALL;USE XILINXCORELIB.CONVOLUTION_PACK_V6_1.ALL;ENTITY CONVOLUTION_V6_1 IS GENERIC(
C_OUTPUT_RATE:INTEGER:=IOOOlI0llOIl11IO01100OI1llOIIOIIII;C_CONSTRAINT_LENGTH:INTEGER:=IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII;C_PUNCTURED:INTEGER:=
II1001IO0010Oll1I01lOI0I0IlIOIIIII;C_DUAL_CHANNEL:INTEGER:=0;C_PUNC_INPUT_RATE:INTEGER:=IO110I1O0010OIOlIO00l1IIOl0llIIIII;C_PUNC_OUTPUT_RATE:INTEGER:=
IIIOOIO01011011IOIIlllIIOO0l1IIIII;C_CONVOLUTION_CODE0:INTEGER:=II1IOOO00I0OI0O01I000O100llOOIIIII;C_CONVOLUTION_CODE1:INTEGER:=
II00OI0110lI1II101lO1OO00I10OIIIII;C_CONVOLUTION_CODE2:INTEGER:=II00OIlIlO101I0IIOO0O1I0ll0OIIIIII;C_CONVOLUTION_CODE3:INTEGER:=
IOOI1l1OO01O111lO010OlO1O0l0IIIIII;C_CONVOLUTION_CODE4:INTEGER:=IO11OllII1lO110Ol0I0O00I01l00IIIII;C_CONVOLUTION_CODE5:INTEGER:=
III01lO1l00IOOO0O0I0O0I111O0IIIIII;C_CONVOLUTION_CODE6:INTEGER:=IO1I1l01l1OI111Ol0IO10110I11IOIIII;C_PUNC_CODE0:INTEGER:=IOOll1I1OOlO0lOO0IIII1lO11IIlIIIII;
C_PUNC_CODE1:INTEGER:=IIIOI11O0OO00OllOllO00lOI000IOIIII;C_HAS_ND:INTEGER:=IIOIOOO11l0lO001OI10I0IIIIlIIIIIII;C_HAS_RFD:INTEGER:=II0IO0I0Olll01OOO0lIOO01lOlIOOIIII;C_HAS_RDY:INTEGER
:=IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII;C_HAS_FD:INTEGER:=II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII;C_HAS_RFFD:INTEGER:=IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII;C_HAS_CE:INTEGER:=IO0O10O101OOIOOl10lIIO101lIIIIIIII;C_HAS_ACLR
:INTEGER:=IIIO0lOII1OIlOOIO1IlI1lIIO001IIIII;C_HAS_SCLR:INTEGER:=IIIIl1100lOI0I1OO1I00OlI0l10IIIIII);PORT(DATA_IN:IN STD_LOGIC:='0';DATA_OUT_V:OUT STD_LOGIC_VECTOR(
C_OUTPUT_RATE-1 DOWNTO 0);DATA_OUT_S:OUT STD_LOGIC;FD_IN:IN STD_LOGIC:='0';ND:IN STD_LOGIC:='0';RFD:OUT STD_LOGIC;RFFD:OUT STD_LOGIC
;RDY:OUT STD_LOGIC;CE:IN STD_LOGIC:='0';SCLR:IN STD_LOGIC:='0';ACLR:IN STD_LOGIC:='0';CLK:IN STD_LOGIC:='0');END;ARCHITECTURE
 BEHAVIORAL OF CONVOLUTION_V6_1 IS CONSTANT IO0IlO1lI10Il011101l101IIl0IOIIIII:INTEGER:=C_PUNC_INPUT_RATE*2;CONSTANT IOI1O00I10101l0I1001llOOI0I0IOIIII:INTEGER:=
C_PUNC_OUTPUT_RATE;CONSTANT IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII:TIME:=1 NS;FUNCTION IO1Il1I0OOOOIl0IOO011l1I0111OIIIII(IO0l0IOllOl1100O10O1O1l0lIO1OIIIII:INTEGER)RETURN INTEGER IS VARIABLE IIlOO000I01110Ill0l1OI1l10IOIOIIII:INTEGER:=0
;VARIABLE II1011O1IO1l0llOI11lIIOIlOlIlIIIII:INTEGER:=IO0l0IOllOl1100O10O1O1l0lIO1OIIIII;BEGIN FOR IOO0I1l1IOO0II0O00I0IllOOI1OOIIIII IN 0 TO C_CONSTRAINT_LENGTH-1 LOOP IIlOO000I01110Ill0l1OI1l10IOIOIIII:=2*IIlOO000I01110Ill0l1OI1l10IOIOIIII;IF(II1011O1IO1l0llOI11lIIOIlOlIlIIIII REM 2=1)THEN
 IIlOO000I01110Ill0l1OI1l10IOIOIIII:=IIlOO000I01110Ill0l1OI1l10IOIOIIII+1;END IF;II1011O1IO1l0llOI11lIIOIlOlIlIIIII:=II1011O1IO1l0llOI11lIIOIlOlIlIIIII/2;END LOOP;RETURN IIlOO000I01110Ill0l1OI1l10IOIOIIII;END;FUNCTION IOI01l1I0000lIO0IIO01IlIO1001IIIII(IOI0IIll0I0l1IO0I01lO110IIIIIOIIII:INTEGER;IO00l1I0I1IOlII011Il0l0lOI0OIIIIII:
IIIO1O1110Oll10OI110OIIO111OOIIIII;IO01l1ll0IlOll0I00lll11l0OllIIIIII,IOI11IOIlOI1II1Il11OlI01Illl0IIIII:INTEGER)RETURN INTEGER IS VARIABLE IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII:IIIO1O1110Oll10OI110OIIO111OOIIIII:=IO00l1I0I1IOlII011Il0l0lOI0OIIIIII;VARIABLE
 IOlIOOI0O1OIlOl01O0OIII10O11lIIIII:INTEGER:=0;BEGIN FOR IO1OIOI0I1l11O0IllIOllII1llIIOIIII IN 0 TO C_PUNC_INPUT_RATE-1 LOOP FOR IIOOO0OOIll110IlI1111I1001I01IIIII IN 0 TO IO01l1ll0IlOll0I00lll11l0OllIIIIII-1 LOOP IF(IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII(IIOOO0OOIll110IlI1111I1001I01IIIII)MOD 2=1)THEN IF(
IOlIOOI0O1OIlOl01O0OIII10O11lIIIII=IOI0IIll0I0l1IO0I01lO110IIIIIOIIII)THEN RETURN IIOOO0OOIll110IlI1111I1001I01IIIII;END IF;IOlIOOI0O1OIlOl01O0OIII10O11lIIIII:=IOlIOOI0O1OIlOl01O0OIII10O11lIIIII+1;END IF;IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII(IIOOO0OOIll110IlI1111I1001I01IIIII):=IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII(IIOOO0OOIll110IlI1111I1001I01IIIII)/2;END LOOP;EXIT WHEN(IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII(0)=0 AND IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII(1)=0);END
 LOOP;RETURN 0;END;FUNCTION IO00lII1lIll0OllOlI1l1O0OI100IIIII(IIII1llIll1l01O1l1O0OIlO1l00OIIIII:INTEGER;II10ll00IlO1IIOIOIO10II0lI1l0IIIII:IIIO1O1110Oll10OI110OIIO111OOIIIII;IOIIOIIO1lIIOOl0IlO11I00II110IIIII,II0Ol0OI111lIO001O0IIlO110IlIOIIII:INTEGER)RETURN
 INTEGER IS VARIABLE II1ll00lO01110lOI1I0IOO0IlO0IIIIII:IIIO1O1110Oll10OI110OIIO111OOIIIII:=II10ll00IlO1IIOIOIO10II0lI1l0IIIII;VARIABLE IO0I011OOl0OOO000O0I0O0OO0OllIIIII:INTEGER:=0;BEGIN FOR IO1OllI0IIll0OIOI1l01I010OOIOOIIII IN 0 TO C_PUNC_INPUT_RATE-1 LOOP
 FOR IIOl11l1l101llOl0l0l101I1O1llIIIII IN 0 TO IOIIOIIO1lIIOOl0IlO11I00II110IIIII-1 LOOP IF(II1ll00lO01110lOI1I0IOO0IlO0IIIIII(IIOl11l1l101llOl0l0l101I1O1llIIIII)MOD 2=1)THEN IF(IO0I011OOl0OOO000O0I0O0OO0OllIIIII=IIII1llIll1l01O1l1O0OIlO1l00OIIIII)THEN RETURN C_PUNC_INPUT_RATE-1-IO1OllI0IIll0OIOI1l01I010OOIOOIIII;END IF;IO0I011OOl0OOO000O0I0O0OO0OllIIIII:=
IO0I011OOl0OOO000O0I0O0OO0OllIIIII+1;END IF;II1ll00lO01110lOI1I0IOO0IlO0IIIIII(IIOl11l1l101llOl0l0l101I1O1llIIIII):=II1ll00lO01110lOI1I0IOO0IlO0IIIIII(IIOl11l1l101llOl0l0l101I1O1llIIIII)/2;END LOOP;EXIT WHEN(II1ll00lO01110lOI1I0IOO0IlO0IIIIII(0)=0 AND II1ll00lO01110lOI1I0IOO0IlO0IIIIII(1)=0);END LOOP;RETURN 0;END;FUNCTION III1O0Ol0IOOO0IllIOOO000O1lO0IIIII(
IIl1IIO111llI0l1O1OI00lIl1I0OIIIII,IIIOOI1II1O11lOIOlOIlOOII1010IIIII:INTEGER;IO0I0I00IO00I1O0I0O0OIOOOI11IOIIII:IIIO1O1110Oll10OI110OIIO111OOIIIII;IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII,IOOI0OO0l1O1O000lO10OOllOIIIIOIIII:INTEGER)RETURN INTEGER IS VARIABLE IO1IllOO0II1ll1OII0OOO10OO0I1IIIII:
IIIO1O1110Oll10OI110OIIO111OOIIIII:=IO0I0I00IO00I1O0I0O0OIOOOI11IOIIII;VARIABLE IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII:INTEGER:=0;VARIABLE IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII:INTEGER:=IIIOOI1II1O11lOIOlOIlOOII1010IIIII*2+IIl1IIO111llI0l1O1OI00lIl1I0OIIIII;BEGIN FOR II10110Oll1OOlIOlOlIl01111IlOIIIII IN 0 TO
 IO0IlO1lI10Il011101l101IIl0IOIIIII-1 LOOP FOR IOIO00lO11l0IOO1l0I101I11l1OOIIIII IN 0 TO IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII-1 LOOP IF(IO1IllOO0II1ll1OII0OOO10OO0I1IIIII(IOIO00lO11l0IOO1l0I101I11l1OOIIIII)REM 2=1)THEN IF(IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII=IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII)THEN RETURN IOIO00lO11l0IOO1l0I101I11l1OOIIIII;END IF;IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII:=
IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII+1;END IF;IO1IllOO0II1ll1OII0OOO10OO0I1IIIII(IOIO00lO11l0IOO1l0I101I11l1OOIIIII):=IO1IllOO0II1ll1OII0OOO10OO0I1IIIII(IOIO00lO11l0IOO1l0I101I11l1OOIIIII)/2;END LOOP;EXIT WHEN(IO1IllOO0II1ll1OII0OOO10OO0I1IIIII(0)=0 AND IO1IllOO0II1ll1OII0OOO10OO0I1IIIII(1)=0);END LOOP;RETURN 0;END;FUNCTION IIIIl0I1lO1llIOIOOO1lOl11IIlOIIIII(
II0l0O0IOlIOI00OIl0IlOlI01OI1IIIII,IIlO0l11I10OOIl000I0OOIO0IO0IIIIII:INTEGER;IIOIOOI1ll1O0I1011l0O1lI0IllIOIIII:IIIO1O1110Oll10OI110OIIO111OOIIIII;IOIlllIIlI1OlI0l101llI0II1O1IOIIII,IOO0IO0OOOOO0I10II0llO10ll1OlIIIII:INTEGER)RETURN INTEGER IS VARIABLE IIlIII1OIIl0OOl00I0IlOOI1IIlOIIIII:
IIIO1O1110Oll10OI110OIIO111OOIIIII:=IIOIOOI1ll1O0I1011l0O1lI0IllIOIIII;VARIABLE IOl10OI01O100l1IIIl0IIl1lO10lIIIII:INTEGER:=0;VARIABLE IOI1l0OI1IO0llll1llO11Ol1IIlIIIIII:INTEGER:=2*IIlO0l11I10OOIl000I0OOIO0IO0IIIIII+II0l0O0IOlIOI00OIl0IlOlI01OI1IIIII;BEGIN FOR IO00l1II1l000l0I11O010I1IlOlIOIIII IN 0 TO
 IO0IlO1lI10Il011101l101IIl0IOIIIII-1 LOOP FOR II0IO0O1III0I1I1OlI0011O001IOIIIII IN 0 TO IOIlllIIlI1OlI0l101llI0II1O1IOIIII-1 LOOP IF(IIlIII1OIIl0OOl00I0IlOOI1IIlOIIIII(II0IO0O1III0I1I1OlI0011O001IOIIIII)REM 2=1)THEN IF(IOl10OI01O100l1IIIl0IIl1lO10lIIIII=IOI1l0OI1IO0llll1llO11Ol1IIlIIIIII)THEN RETURN IO0IlO1lI10Il011101l101IIl0IOIIIII-1-IO00l1II1l000l0I11O010I1IlOlIOIIII;END
 IF;IOl10OI01O100l1IIIl0IIl1lO10lIIIII:=IOl10OI01O100l1IIIl0IIl1lO10lIIIII+1;END IF;IIlIII1OIIl0OOl00I0IlOOI1IIlOIIIII(II0IO0O1III0I1I1OlI0011O001IOIIIII):=IIlIII1OIIl0OOl00I0IlOOI1IIlOIIIII(II0IO0O1III0I1I1OlI0011O001IOIIIII)/2;END LOOP;EXIT WHEN(IIlIII1OIIl0OOl00I0IlOOI1IIlOIIIII(0)=0 AND IIlIII1OIIl0OOl00I0IlOOI1IIlOIIIII(1)=0);END LOOP;RETURN 0;END;CONSTANT
 IIl1OOO111O0O11l1OOllOIIIIIl0IIIII:INTEGER:=C_OVERRIDE;SIGNAL IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII,IOl1I001lIl1Il1I11lI00l11O1OOIIIII,IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII,III0l0O0I11OOO1lI0OOIO0llOlIlIIIII,IOO01101I01OlOIO111IIl0OOIOI0IIIII,II00l0IOI1lIlOlOOI0I011O1110OIIIII:STD_LOGIC;SIGNAL IOIO1OI0IlI1I1010lO000IO01Ol0IIIII:STD_LOGIC_VECTOR(
C_OUTPUT_RATE-1 DOWNTO 0):=(OTHERS=>'0');SIGNAL IIO00Il10lI0OOllOOO0lO11lOOlIOIIII,IIIIOOlIIO11011I1IlOO10OOOO0OIIIII:STD_LOGIC_VECTOR(C_OUTPUT_RATE-1 DOWNTO 0):=(OTHERS=>
'0');SIGNAL IIO0101IlI11I0IOlI01l1ll0O10OIIIII:STD_LOGIC:='1';SIGNAL IOl00OIO0IOOllO1I1O101lIIl11OIIIII:STD_LOGIC:='1';SIGNAL IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII,IO00OI0ll1l1l0llI1I000OOO0010IIIII:STD_LOGIC;SIGNAL IOl0OIIOl0O00OO0lI0I0O1IO1OOIOIIII,IOI0111Il0IllIIO0O0lO0I111010IIIII,IOO0IOIOOll0Il0OlI001lIIIOOOIIIIII:STD_LOGIC;
SIGNAL IOO0llOIlIO0110l1lOO01I00l1OIIIIII,IOIO0OOIOIOl0OIllO011O11O0OOIIIIII:STD_LOGIC;SIGNAL IO0lI0OlO11O10O1III000O01l0l0IIIII,IIO1O00llO01OII1I11lIIO001lI0IIIII,IOIl1lI1IO111IO0OII101O1I0l0IOIIII:STD_LOGIC;SIGNAL IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII,IO01O100lOO0IOOI000OO1lIOO1l0IIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII:STD_LOGIC;SIGNAL
 IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII:STD_LOGIC;SIGNAL IIOIlOO1lI01O10O1Ol0OOI10110OIIIII:STD_LOGIC_VECTOR(C_OUTPUT_RATE-1 DOWNTO 0);SIGNAL IO0II1lll1llOlO1lll1001O1IlOIOIIII:STD_LOGIC;SIGNAL
 IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:STD_LOGIC;SIGNAL IIlIIII1lOllO0IlO11I1O01110IOIIIII:STD_LOGIC;SIGNAL II0I1I1l00l1O11OOIOIIllII10IlIIIII:STD_LOGIC;SIGNAL III0lIIOOIOl0ll0ll0l1lO10IlIIIIIII:STD_LOGIC;SIGNAL
 III010I1Ol1OlOI0IO10O0000II11IIIII:STD_LOGIC;SIGNAL IOIlOO00I1I00lO00l0I00OlIO01IIIIII:STD_LOGIC;SIGNAL IIO111Il00001lO0l00lOOlI1IO10IIIII:STD_LOGIC;SIGNAL II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:
STD_LOGIC;SIGNAL IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII:STD_LOGIC;SIGNAL IO0I10OO0llIIlII1I01OOI001IIIIIIII:STD_LOGIC;SIGNAL II110IlI0l101IO1IlI1O00llI00OIIIII:STD_LOGIC;SIGNAL III0O000IO1IOIO10l0I00lOIII11IIIII:
STD_LOGIC;SIGNAL II1llIOlOlll00O010O1lI1IOI1I1IIIII:STD_LOGIC;SIGNAL IO1I11OIllI1III1III11OlIIlIIOIIIII:STD_LOGIC;SIGNAL IIl11lIlOO0IIII0IOlI0l1000I1IIIIII:STD_LOGIC_VECTOR(7 DOWNTO 0);SIGNAL
 IOOI10l11llO01llIIllOI1IO0l1OIIIII:STD_LOGIC_VECTOR(7 DOWNTO 0);SIGNAL IOO1IIll11IlI110IOlllI1Il1IO1IIIII:STD_LOGIC_VECTOR(IOI1O00I10101l0I1001llOOI0I0IOIIII-1 DOWNTO 0);SIGNAL
 IOO000O0Ol1OlIOOI00l11I1l1I00IIIII:STD_LOGIC_VECTOR(IOI1O00I10101l0I1001llOOI0I0IOIIII-1 DOWNTO 0);SIGNAL IIll0O11l1O1lOl111IIOlOIl0I0OIIIII:STD_LOGIC_VECTOR(IOI1O00I10101l0I1001llOOI0I0IOIIII-1 DOWNTO 0);
SIGNAL IIOI10lI0II00O0IOOl0I10001lO1IIIII:STD_LOGIC_VECTOR(C_PUNC_INPUT_RATE-1 DOWNTO 0);SIGNAL IIO1IIOOO0OO1100OO11l0OOllIIIOIIII:STD_LOGIC_VECTOR(C_CONSTRAINT_LENGTH-1
 DOWNTO 0);TYPE IOO01O011lIIIlOl1O0lOIOOI110IOIIII IS ARRAY(0 TO C_OUTPUT_RATE-1)OF STD_LOGIC_VECTOR(C_PUNC_INPUT_RATE-1 DOWNTO 0);SIGNAL IOIOO101OO01Ol1101l1O01O1OOllIIIII,
IIOO0IIlO0O0I01l00I1011II0011IIIII:IOO01O011lIIIlOl1O0lOIOOI110IOIIII;BEGIN CHECK_GENERICS:PROCESS VARIABLE IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII:INTEGER:=(2**C_CONSTRAINT_LENGTH)-1;BEGIN IF(C_CONSTRAINT_LENGTH
>IOO0111OO0lOOl10l1l000l0OlI0IIIIII)THEN ASSERT FALSE REPORT"Selected constraint length is "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(C_OUTPUT_RATE<2 OR
 C_OUTPUT_RATE>IO1lll0I0l0l1ll1O01Ol0III011IOIIII)THEN ASSERT FALSE REPORT"Output rate for encoder must be between 2 and 7 "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;
END IF;IF((IIl0OIlO00I0lI101l1I0lO1II0IlIIIII(C_CONVOLUTION_CODE0,32)>C_CONSTRAINT_LENGTH)OR(C_CONVOLUTION_CODE0>IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII))THEN ASSERT FALSE REPORT
"Convolution code 0 is greater than constraint length "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((C_CONVOLUTION_CODE0=0)AND(C_OUTPUT_RATE>0
))THEN ASSERT FALSE REPORT"Convolution code 0 must be greater than zero "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((IIl0OIlO00I0lI101l1I0lO1II0IlIIIII(
C_CONVOLUTION_CODE1,32)>C_CONSTRAINT_LENGTH)OR(C_CONVOLUTION_CODE1>IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII))THEN ASSERT FALSE REPORT
"Convolution code 1 is greater than constraint length "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((C_CONVOLUTION_CODE1=0)AND(C_OUTPUT_RATE>1
))THEN ASSERT FALSE REPORT"Convolution code 1 must be greater than zero "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((IIl0OIlO00I0lI101l1I0lO1II0IlIIIII(
C_CONVOLUTION_CODE2,32)>C_CONSTRAINT_LENGTH)OR(C_CONVOLUTION_CODE2>IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII))THEN ASSERT FALSE REPORT
"Convolution code 2 is greater than constraint length "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((C_CONVOLUTION_CODE2=0)AND(C_OUTPUT_RATE>2
))THEN ASSERT FALSE REPORT"Convolution code 2 must be greater than zero "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((IIl0OIlO00I0lI101l1I0lO1II0IlIIIII(
C_CONVOLUTION_CODE3,32)>C_CONSTRAINT_LENGTH)OR(C_CONVOLUTION_CODE3>IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII))THEN ASSERT FALSE REPORT
"Convolution code 3 is greater than constraint length "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((C_CONVOLUTION_CODE3=0)AND(C_OUTPUT_RATE>3
))THEN ASSERT FALSE REPORT"Convolution code 3 must be greater than zero "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((IIl0OIlO00I0lI101l1I0lO1II0IlIIIII(
C_CONVOLUTION_CODE4,32)>C_CONSTRAINT_LENGTH)OR(C_CONVOLUTION_CODE4>IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII))THEN ASSERT FALSE REPORT
"Convolution code 4 is greater than constraint length "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((C_CONVOLUTION_CODE4=0)AND(C_OUTPUT_RATE>4
))THEN ASSERT FALSE REPORT"Convolution code 4 must be greater than zero "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((IIl0OIlO00I0lI101l1I0lO1II0IlIIIII(
C_CONVOLUTION_CODE5,32)>C_CONSTRAINT_LENGTH)OR(C_CONVOLUTION_CODE5>IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII))THEN ASSERT FALSE REPORT
"Convolution code 5 is greater than constraint length "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((C_CONVOLUTION_CODE5=0)AND(C_OUTPUT_RATE>5
))THEN ASSERT FALSE REPORT"Convolution code 5 must be greater than zero "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((IIl0OIlO00I0lI101l1I0lO1II0IlIIIII(
C_CONVOLUTION_CODE6,32)>C_CONSTRAINT_LENGTH)OR(C_CONVOLUTION_CODE6>IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII))THEN ASSERT FALSE REPORT
"Convolution code 6 is greater than constraint length "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF((C_CONVOLUTION_CODE6=0)AND(C_OUTPUT_RATE>6
))THEN ASSERT FALSE REPORT"Convolution code 6 must be greater than zero "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(C_PUNCTURED=0)THEN IF(
C_HAS_FD/=0)THEN ASSERT FALSE REPORT"FD cannot be present in non-punctured coding "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(C_HAS_RFFD/=0
)THEN ASSERT FALSE REPORT"RFFD cannot be present in non-punctured coding "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;END IF;IF(C_PUNCTURED=1)
THEN IF((C_PUNC_OUTPUT_RATE>(2*C_PUNC_INPUT_RATE-1))AND(C_PUNC_OUTPUT_RATE<C_PUNC_INPUT_RATE+1))THEN ASSERT FALSE REPORT
"Invalid punctured output rate: must be greater than "&IOII100I0I1l010IOI1lO1O1I1101IIIII(C_PUNC_INPUT_RATE)&" less than "&IOII100I0I1l010IOI1lO1O1I1101IIIII(2*
C_PUNC_INPUT_RATE)&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(C_OUTPUT_RATE/=2)THEN ASSERT FALSE REPORT
"Output rate must be equal to 2 for puncture "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(C_PUNC_INPUT_RATE>IIlO1lIIlOlOOO0l10OI1ll0I0O10IIIII)THEN ASSERT
 FALSE REPORT"Punc Input rate must be less than or equal to "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(IIl0OIlO00I0lI101l1I0lO1II0IlIIIII(C_PUNC_CODE0,32)>
C_PUNC_INPUT_RATE)THEN ASSERT FALSE REPORT"Puncture code 0 length can not exceed "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(IIl0OIlO00I0lI101l1I0lO1II0IlIIIII(
C_PUNC_CODE1,32)>C_PUNC_INPUT_RATE)THEN ASSERT FALSE REPORT"Puncture code 1 length can not exceed "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;
IF(II011lO0O1l10O0I0OIOO000I0O1IOIIII(C_PUNC_CODE0)+II011lO0O1l10O0I0OIOO000I0O1IOIIII(C_PUNC_CODE1)/=(C_PUNC_OUTPUT_RATE))THEN ASSERT FALSE REPORT
"Invalid punture codes - number of total 1's in puncture code must be "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(C_HAS_ND/=1 AND
 C_DUAL_CHANNEL=0)THEN ASSERT FALSE REPORT"ND signal required for punctured coding "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(C_HAS_RFD/=1
 AND C_DUAL_CHANNEL=0)THEN ASSERT FALSE REPORT"RFD signal required for punctured coding "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;IF(
C_HAS_RDY/=1)THEN ASSERT FALSE REPORT"RDY signal required for punctured coding "&II1IOOO1II0l1lOl00I1O001I00O0IIIII SEVERITY ERROR;END IF;END IF;WAIT;END
 PROCESS;GENERATE_INPUTS:PROCESS(DATA_IN,ACLR,SCLR,CE,FD_IN,ND)BEGIN IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII<=DATA_IN;IF(C_HAS_ACLR=1)THEN IOO01101I01OlOIO111IIl0OOIOI0IIIII<=ACLR;ELSE
 IOO01101I01OlOIO111IIl0OOIOI0IIIII<='0';END IF;IF(C_HAS_SCLR=1)THEN II00l0IOI1lIlOlOOI0I011O1110OIIIII<=SCLR;ELSE II00l0IOI1lIlOlOOI0I011O1110OIIIII<='0';END IF;IF(C_HAS_CE=1)THEN III0l0O0I11OOO1lI0OOIO0llOlIlIIIII<=CE;ELSE III0l0O0I11OOO1lI0OOIO0llOlIlIIIII<='1';END IF;IF(
C_HAS_ND=1)THEN IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII<=ND;ELSE IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII<='1';END IF;IF(C_HAS_FD=1)THEN IOl1I001lIl1Il1I11lI00l11O1OOIIIII<=FD_IN;ELSE IOl1I001lIl1Il1I11lI00l11O1OOIIIII<='0';END IF;END PROCESS;CONVOLVE:PROCESS(CLK
,IOO01101I01OlOIO111IIl0OOIOI0IIIII,II00l0IOI1lIlOlOOI0I011O1110OIIIII,III0l0O0I11OOO1lI0OOIO0llOlIlIIIII,IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII,IIO0101IlI11I0IOlI01l1ll0O10OIIIII)VARIABLE IIOlI0O00IO011lIIOl100O001lIOOIIII:STD_LOGIC_VECTOR(C_CONSTRAINT_LENGTH-1 DOWNTO 0):=(OTHERS=>'0');
VARIABLE III0IlIOll1Ill0I0I0OlIO10I1I1IIIII:STD_LOGIC_VECTOR(C_OUTPUT_RATE-1 DOWNTO 0);VARIABLE IOOllIl0I1ll0lII0IOIIO1lI10IIIIIII:STD_LOGIC_VECTOR(C_OUTPUT_RATE-1 DOWNTO 0);
VARIABLE II0I1O11OOll0l0I11O110OlI0lIOOIIII:IOlI00I100IOOOl011O11IOI1l010IIIII:=(IO1Il1I0OOOOIl0IOO011l1I0111OIIIII(C_CONVOLUTION_CODE0),IO1Il1I0OOOOIl0IOO011l1I0111OIIIII(C_CONVOLUTION_CODE1),IO1Il1I0OOOOIl0IOO011l1I0111OIIIII(
C_CONVOLUTION_CODE2),IO1Il1I0OOOOIl0IOO011l1I0111OIIIII(C_CONVOLUTION_CODE3),IO1Il1I0OOOOIl0IOO011l1I0111OIIIII(C_CONVOLUTION_CODE4),IO1Il1I0OOOOIl0IOO011l1I0111OIIIII(C_CONVOLUTION_CODE5),
IO1Il1I0OOOOIl0IOO011l1I0111OIIIII(C_CONVOLUTION_CODE6));VARIABLE II1lI1l0l00llI0l0l1O0OOII10I1IIIII:STD_LOGIC_VECTOR(C_CONSTRAINT_LENGTH-1 DOWNTO 0);VARIABLE II0l10llII1lO0O1lOIlOOI10I0lIIIIII:STD_LOGIC
;VARIABLE IO1I1OlOI1OII110llI1lI0IIl0O0IIIII:BOOLEAN:=TRUE;BEGIN IF(IO1I1OlOI1OII110llI1lI0IIl0O0IIIII)THEN IO1I1OlOI1OII110llI1lI0IIl0O0IIIII:=FALSE;IOIO1OI0IlI1I1010lO000IO01Ol0IIIII<=(OTHERS=>'0');III0IlIOll1Ill0I0I0OlIO10I1I1IIIII:=(OTHERS=>'0');
IOOllIl0I1ll0lII0IOIIO1lI10IIIIIII:=(OTHERS=>'0');END IF;IF(IOO01101I01OlOIO111IIl0OOIOI0IIIII'event AND IOO01101I01OlOIO111IIl0OOIOI0IIIII='1')THEN III0IlIOll1Ill0I0I0OlIO10I1I1IIIII:=(OTHERS=>'0');IOOllIl0I1ll0lII0IOIIO1lI10IIIIIII:=(OTHERS=>'0');
IIOlI0O00IO011lIIOl100O001lIOOIIII:=(OTHERS=>'0');IOIO1OI0IlI1I1010lO000IO01Ol0IIIII<=(OTHERS=>'0');ELSIF(IOO01101I01OlOIO111IIl0OOIOI0IIIII'event AND IOO01101I01OlOIO111IIl0OOIOI0IIIII='0')THEN ELSIF(CLK'event AND CLK='1'AND IOO01101I01OlOIO111IIl0OOIOI0IIIII=
'0')THEN IF(II00l0IOI1lIlOlOOI0I011O1110OIIIII='0'AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='1')THEN IOOllIl0I1ll0lII0IOIIO1lI10IIIIIII:=III0IlIOll1Ill0I0I0OlIO10I1I1IIIII;END IF;IF(II00l0IOI1lIlOlOOI0I011O1110OIIIII='0'AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='1'AND IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1'AND IOl1100I00OlIllOI1I0III1O1l01IIIII='1')THEN
 IIOlI0O00IO011lIIOl100O001lIOOIIII(C_CONSTRAINT_LENGTH-1 DOWNTO 1):=IIOlI0O00IO011lIIOl100O001lIOOIIII(C_CONSTRAINT_LENGTH-2 DOWNTO 0);IIOlI0O00IO011lIIOl100O001lIOOIIII(0):=IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII;FOR II110IO0lllI1lOI110IO00I1lOlIIIIII IN 0 TO
 C_OUTPUT_RATE-1 LOOP II0l10llII1lO0O1lOIlOOI10I0lIIIIII:='0';II1lI1l0l00llI0l0l1O0OOII10I1IIIII:=IIlOllOOI0ll11O1101IIl0l11ll1IIIII(II0I1O11OOll0l0I11O110OlI0lIOOIIII(II110IO0lllI1lOI110IO00I1lOlIIIIII),C_CONSTRAINT_LENGTH);FOR IIl110lllO10l0llOI11l01I0I1OlIIIII IN 0 TO
 C_CONSTRAINT_LENGTH-1 LOOP II0l10llII1lO0O1lOIlOOI10I0lIIIIII:=II0l10llII1lO0O1lOIlOOI10I0lIIIIII XOR(IIOlI0O00IO011lIIOl100O001lIOOIIII(IIl110lllO10l0llOI11l01I0I1OlIIIII)AND II1lI1l0l00llI0l0l1O0OOII10I1IIIII(IIl110lllO10l0llOI11l01I0I1OlIIIII));END LOOP;III0IlIOll1Ill0I0I0OlIO10I1I1IIIII(II110IO0lllI1lOI110IO00I1lOlIIIIII):=II0l10llII1lO0O1lOIlOOI10I0lIIIIII;END LOOP
;ELSIF((II00l0IOI1lIlOlOOI0I011O1110OIIIII='1')AND(III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='1'))THEN III0IlIOll1Ill0I0I0OlIO10I1I1IIIII:=(OTHERS=>'0');IOOllIl0I1ll0lII0IOIIO1lI10IIIIIII:=(OTHERS=>'0');IIOlI0O00IO011lIIOl100O001lIOOIIII:=(OTHERS=>'0');END IF;END
 IF;IOIO1OI0IlI1I1010lO000IO01Ol0IIIII<=IOOllIl0I1ll0lII0IOIIO1lI10IIIIIII;IIIIOOlIIO11011I1IlOO10OOOO0OIIIII<=III0IlIOll1Ill0I0I0OlIO10I1I1IIIII;IIO1IIOOO0OO1100OO11l0OOllIIIOIIII<=IIOlI0O00IO011lIIOl100O001lIOOIIII;END PROCESS;PUNCTURE:PROCESS(CLK,
IIO00Il10lI0OOllOOO0lO11lOOlIOIIII,IO01O100lOO0IOOI000OO1lIOO1l0IIIII,IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII,III0l0O0I11OOO1lI0OOIO0llOlIlIIIII,IOO01101I01OlOIO111IIl0OOIOI0IIIII,II00l0IOI1lIlOlOOI0I011O1110OIIIII,IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII,IOl1I001lIl1Il1I11lI00l11O1OOIIIII)VARIABLE IOOll11IO1O1llOIl10010O1IIOOIIIIII:BOOLEAN:=TRUE;VARIABLE IIII00I101O111lII1O000IO1lOOIIIIII,IOOI01II11O1I1IOII1II01O1001lIIIII,
IO111Il1I1O0lO1OlOI0l01I1O010IIIII:IOO01O011lIIIlOl1O0lOIOOI110IOIIII;VARIABLE III011IIIl1IO1l0O11000I0llI00IIIII,II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII:INTEGER;VARIABLE IIO1l1Ol1l11Il0000II00lI011I0IIIII,IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII,II1lI11lI1II1000lOllIOl01l0l0IIIII:STD_LOGIC;VARIABLE II0l0001lI0I0IlllI1I100OO10IIIIIII:
STD_LOGIC;VARIABLE II01l0llO10l10II111lIlOIllO0lIIIII:STD_LOGIC;VARIABLE IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII:STD_LOGIC;VARIABLE IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:STD_LOGIC;VARIABLE IIl1O01ll1111l0llIOO0OOl1ll0IOIIII
,II10l111IOllO0O1111Ill001lll1IIIII,IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:STD_LOGIC_VECTOR(IOI1O00I10101l0I1001llOOI0I0IOIIII-1 DOWNTO 0);VARIABLE IIll1lO0l0lI0OII00l00OO11IlO1IIIII:IIIO1O1110Oll10OI110OIIO111OOIIIII:=(C_PUNC_CODE0,C_PUNC_CODE1);
VARIABLE III00O11l11IlIOI1llIIIOII100lIIIII,IO1l01O110OIl00l10lOOlI0lI0I0IIIII:STD_LOGIC;VARIABLE IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII:STD_LOGIC;VARIABLE IOIIOO1001lI01IOOlOllIOOIO1O1IIIII:STD_LOGIC;VARIABLE IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:
STD_LOGIC;VARIABLE III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:STD_LOGIC;VARIABLE IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:STD_LOGIC;VARIABLE IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:STD_LOGIC;VARIABLE III11I01Ol11IOO00IOI1I11OOl10IIIII:STD_LOGIC;
VARIABLE IIl1lOIllIlIl01ll00O11OIl100IOIIII:STD_LOGIC;VARIABLE IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII:INTEGER;VARIABLE II1011l1lI11IlIlI0l0l00100lO0IIIII:INTEGER;BEGIN IF(C_PUNCTURED=1 AND C_DUAL_CHANNEL=0
)THEN IF(IOOll11IO1O1llOIl10010O1IIOOIIIIII)THEN IOOll11IO1O1llOIl10010O1IIOOIIIIII:=FALSE;FOR IO1OO10IOIO11O10IOOOllllI1Il0IIIII IN 0 TO C_OUTPUT_RATE-1 LOOP IIII00I101O111lII1O000IO1lOOIIIIII(IO1OO10IOIO11O10IOOOllllI1Il0IIIII):=(OTHERS=>'0');IOOI01II11O1I1IOII1II01O1001lIIIII(IO1OO10IOIO11O10IOOOllllI1Il0IIIII):=(OTHERS=>'0');
IO111Il1I1O0lO1OlOI0l01I1O010IIIII(IO1OO10IOIO11O10IOOOllllI1Il0IIIII):=(OTHERS=>'0');END LOOP;III011IIIl1IO1l0O11000I0llI00IIIII:=0;II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII:=0;IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII:=0;IIO1l1Ol1l11Il0000II00lI011I0IIIII:='0';II0l0001lI0I0IlllI1I100OO10IIIIIII:='0';IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII:=
'0';II01l0llO10l10II111lIlOIllO0lIIIII:='0';IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:=(OTHERS=>'0');II10l111IOllO0O1111Ill001lll1IIIII:=(OTHERS=>'0');IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:=(OTHERS=>'0');II1lI11lI1II1000lOllIOl01l0l0IIIII:='0';III00O11l11IlIOI1llIIIOII100lIIIII
:='0';IO1l01O110OIl00l10lOOlI0lI0I0IIIII:='0';IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII:='0';III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:='0';IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:='0';IOIIOO1001lI01IOOlOllIOOIO1O1IIIII:='0';IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:='1';IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:='1';III11I01Ol11IOO00IOI1I11OOl10IIIII:='0'
;IIl1lOIllIlIl01ll00O11OIl100IOIIII:='0';END IF;FOR II1IOl1011OlI0O00l1O10OlllOI0IIIII IN 0 TO IOI1O00I10101l0I1001llOOI0I0IOIIII-1 LOOP IIl1O01ll1111l0llIOO0OOl1ll0IOIIII(II1IOl1011OlI0O00l1O10OlllOI0IIIII):=IO111Il1I1O0lO1OlOI0l01I1O010IIIII(IOI01l1I0000lIO0IIO01IlIO1001IIIII(II1IOl1011OlI0O00l1O10OlllOI0IIIII,IIll1lO0l0lI0OII00l00OO11IlO1IIIII,C_OUTPUT_RATE,
IOI1O00I10101l0I1001llOOI0I0IOIIII))(IO00lII1lIll0OllOlI1l1O0OI100IIIII(II1IOl1011OlI0O00l1O10OlllOI0IIIII,IIll1lO0l0lI0OII00l00OO11IlO1IIIII,C_OUTPUT_RATE,IOI1O00I10101l0I1001llOOI0I0IOIIII));END LOOP;FOR IO1OIOllI1llI01O00IIl0O111IIOOIIII IN 0 TO C_OUTPUT_RATE-1 LOOP IIII00I101O111lII1O000IO1lOOIIIIII(IO1OIOllI1llI01O00IIl0O111IIOOIIII
)(C_PUNC_INPUT_RATE-1 DOWNTO 1):=IOOI01II11O1I1IOII1II01O1001lIIIII(IO1OIOllI1llI01O00IIl0O111IIOOIIII)(C_PUNC_INPUT_RATE-2 DOWNTO 0);IIII00I101O111lII1O000IO1lOOIIIIII(IO1OIOllI1llI01O00IIl0O111IIOOIIII)(0):=IIO00Il10lI0OOllOOO0lO11lOOlIOIIII(IO1OIOllI1llI01O00IIl0O111IIOOIIII);END LOOP;IF(IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1'AND
 IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII='1')THEN III11I01Ol11IOO00IOI1I11OOl10IIIII:='1';ELSE III11I01Ol11IOO00IOI1I11OOl10IIIII:='0';END IF;IF(IOO01101I01OlOIO111IIl0OOIOI0IIIII='1')THEN FOR IO01001lO000lI1lI0IO11lO0I1OlIIIII IN 0 TO C_OUTPUT_RATE-1 LOOP IOOI01II11O1I1IOII1II01O1001lIIIII(IO01001lO000lI1lI0IO11lO0I1OlIIIII):=(
OTHERS=>'0');IO111Il1I1O0lO1OlOI0l01I1O010IIIII(IO01001lO000lI1lI0IO11lO0I1OlIIIII):=(OTHERS=>'0');END LOOP;III011IIIl1IO1l0O11000I0llI00IIIII:=0;IIO1l1Ol1l11Il0000II00lI011I0IIIII:='0';II0l0001lI0I0IlllI1I100OO10IIIIIII:='0';II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII:=0;IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII:=0
;IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII:='0';II01l0llO10l10II111lIlOIllO0lIIIII:='0';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:=(OTHERS=>'0');II10l111IOllO0O1111Ill001lll1IIIII(IOI1O00I10101l0I1001llOOI0I0IOIIII-2 DOWNTO 0):=IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII(IOI1O00I10101l0I1001llOOI0I0IOIIII-1
 DOWNTO 1);II10l111IOllO0O1111Ill001lll1IIIII(IOI1O00I10101l0I1001llOOI0I0IOIIII-1):='0';II1lI11lI1II1000lOllIOl01l0l0IIIII:=IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII(0);III00O11l11IlIOI1llIIIOII100lIIIII:='0';IO1l01O110OIl00l10lOOlI0lI0I0IIIII:='0';IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII:='0';III1I01Ill1l0lOIlO01lO0I1IlIIOIIII
:='0';IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:='0';IOIIOO1001lI01IOOlOllIOOIO1O1IIIII:='0';IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:='1';IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:='1';III11I01Ol11IOO00IOI1I11OOl10IIIII:='0';IIl1lOIllIlIl01ll00O11OIl100IOIIII:='0';ELSIF(CLK'event AND CLK=
'1'AND II00l0IOI1lIlOlOOI0I011O1110OIIIII='0'AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='1')THEN II0l0001lI0I0IlllI1I100OO10IIIIIII:=IIO1l1Ol1l11Il0000II00lI011I0IIIII;IF((IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1'AND III1I01Ill1l0lOIlO01lO0I1IlIIOIIII='0')OR(IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1'AND IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1'))THEN
 IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:='1';ELSE IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:='0';END IF;IF(IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1'AND III1I01Ill1l0lOIlO01lO0I1IlIIOIIII='0')THEN III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:='1';END IF;IF(II01l0llO10l10II111lIlOIllO0lIIIII='1'
)THEN IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:=IIl1O01ll1111l0llIOO0OOl1ll0IOIIII;IO111Il1I1O0lO1OlOI0l01I1O010IIIII:=IOOI01II11O1I1IOII1II01O1001lIIIII;ELSE IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:=II10l111IOllO0O1111Ill001lll1IIIII;END IF;IF II01l0llO10l10II111lIlOIllO0lIIIII='1'THEN IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII:=1;END
 IF;IF(C_HAS_RDY=1)THEN IO1l01O110OIl00l10lOOlI0lI0I0IIIII:=(II01l0llO10l10II111lIlOIllO0lIIIII AND NOT(IO1l01O110OIl00l10lOOlI0lI0I0IIIII))OR(NOT(III00O11l11IlIOI1llIIIOII100lIIIII AND NOT(II01l0llO10l10II111lIlOIllO0lIIIII))AND IO1l01O110OIl00l10lOOlI0lI0I0IIIII);IF
 IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII/=0 THEN II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII:=II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII+1;END IF;IF(II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII=IOI1O00I10101l0I1001llOOI0I0IOIIII-1)THEN III00O11l11IlIOI1llIIIOII100lIIIII:='1';ELSE
 III00O11l11IlIOI1llIIIOII100lIIIII:='0';END IF;IF(II01l0llO10l10II111lIlOIllO0lIIIII='1')THEN III00O11l11IlIOI1llIIIOII100lIIIII:='0';II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII:=0;END IF;IF(II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII=IOI1O00I10101l0I1001llOOI0I0IOIIII)
THEN II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII:=0;IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII:=0;END IF;END IF;II10l111IOllO0O1111Ill001lll1IIIII(IOI1O00I10101l0I1001llOOI0I0IOIIII-2 DOWNTO 0):=IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII(IOI1O00I10101l0I1001llOOI0I0IOIIII-1 DOWNTO 1);
II10l111IOllO0O1111Ill001lll1IIIII(IOI1O00I10101l0I1001llOOI0I0IOIIII-1):='0';II1lI11lI1II1000lOllIOl01l0l0IIIII:=IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII(0);IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII:=IO0lI0OlO11O10O1III000O01l0l0IIIII OR IOl1I001lIl1Il1I11lI00l11O1OOIIIII OR IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII;IF(IIl1lOIllIlIl01ll00O11OIl100IOIIII='1'OR(IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1'
AND IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1'))THEN IOOI01II11O1I1IOII1II01O1001lIIIII:=IIII00I101O111lII1O000IO1lOOIIIIII;END IF;IF(IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1'AND IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII='1')OR(IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1'AND IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1')THEN IF(C_PUNC_INPUT_RATE>2)THEN
 III011IIIl1IO1l0O11000I0llI00IIIII:=III011IIIl1IO1l0O11000I0llI00IIIII+1;END IF;IF(IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII='1')THEN IF(C_PUNC_INPUT_RATE>2)THEN III011IIIl1IO1l0O11000I0llI00IIIII:=0;END IF;END IF;IF(
C_PUNC_INPUT_RATE>2)THEN IF(III011IIIl1IO1l0O11000I0llI00IIIII=C_PUNC_INPUT_RATE-1)THEN IIO1l1Ol1l11Il0000II00lI011I0IIIII:='1';ELSE IIO1l1Ol1l11Il0000II00lI011I0IIIII:='0';END IF;IF(III011IIIl1IO1l0O11000I0llI00IIIII=
C_PUNC_INPUT_RATE)THEN III011IIIl1IO1l0O11000I0llI00IIIII:=0;END IF;END IF;IF(C_PUNC_INPUT_RATE=2)THEN IIO1l1Ol1l11Il0000II00lI011I0IIIII:=(NOT IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII)AND(NOT IIO1l1Ol1l11Il0000II00lI011I0IIIII
);END IF;END IF;II01l0llO10l10II111lIlOIllO0lIIIII:=IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII;IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII:=IIO1l1Ol1l11Il0000II00lI011I0IIIII AND NOT II0l0001lI0I0IlllI1I100OO10IIIIIII;IF C_HAS_RFD/=0 THEN IF(C_PUNC_OUTPUT_RATE-
C_PUNC_INPUT_RATE=1)THEN IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:=NOT IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII;ELSIF(C_PUNC_OUTPUT_RATE-C_PUNC_INPUT_RATE=2)THEN IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:=NOT(IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII OR
 II01l0llO10l10II111lIlOIllO0lIIIII);ELSE IF IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII='1'THEN IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:='0';ELSIF(II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII=C_PUNC_OUTPUT_RATE-C_PUNC_INPUT_RATE-2)THEN IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:='1';END IF
;END IF;END IF;IF C_HAS_RFFD/=0 AND C_HAS_FD/=0 THEN IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:=(IIO1l1Ol1l11Il0000II00lI011I0IIIII AND IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII)OR(NOT IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII);END IF;IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII
:=IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII;IIl1lOIllIlIl01ll00O11OIl100IOIIII:=III11I01Ol11IOO00IOI1I11OOl10IIIII;ELSIF(CLK'event AND CLK='1'AND II00l0IOI1lIlOlOOI0I011O1110OIIIII='1'AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='1')THEN IF(C_HAS_RDY=1)THEN II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII:=0;
III00O11l11IlIOI1llIIIOII100lIIIII:='0';END IF;FOR IOOl11OIOl101I1I1I00lIlIlO00IIIIII IN 0 TO C_OUTPUT_RATE-1 LOOP IO111Il1I1O0lO1OlOI0l01I1O010IIIII(IOOl11OIOl101I1I1I00lIlIlO00IIIIII):=(OTHERS=>'0');IOOI01II11O1I1IOII1II01O1001lIIIII(IOOl11OIOl101I1I1I00lIlIlO00IIIIII):=(OTHERS=>'0');END LOOP;
IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:=(OTHERS=>'0');II10l111IOllO0O1111Ill001lll1IIIII(IOI1O00I10101l0I1001llOOI0I0IOIIII-2 DOWNTO 0):=IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII(IOI1O00I10101l0I1001llOOI0I0IOIIII-1 DOWNTO 1);II10l111IOllO0O1111Ill001lll1IIIII(IOI1O00I10101l0I1001llOOI0I0IOIIII
-1):='0';II1lI11lI1II1000lOllIOl01l0l0IIIII:=IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII(0);IO1l01O110OIl00l10lOOlI0lI0I0IIIII:='0';IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII:='0';III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:='0';IOIIOO1001lI01IOOlOllIOOIO1O1IIIII:='0';IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:='1';IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII:='0';
II01l0llO10l10II111lIlOIllO0lIIIII:='0';III011IIIl1IO1l0O11000I0llI00IIIII:=0;II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII:=0;IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII:=0;IIO1l1Ol1l11Il0000II00lI011I0IIIII:='0';IF C_HAS_RFFD/=0 AND C_HAS_FD/=0 THEN IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:=(
IIO1l1Ol1l11Il0000II00lI011I0IIIII AND IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII)OR(NOT IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII);END IF;IF C_HAS_RFD/=0 THEN IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:='1';END IF;END IF;IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII:=IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII AND NOT
 II01l0llO10l10II111lIlOIllO0lIIIII;IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII<=II1lI11lI1II1000lOllIOl01l0l0IIIII;IOl0OIIOl0O00OO0lI0I0O1IO1OOIOIIII<=IO1l01O110OIl00l10lOOlI0lI0I0IIIII;IOI0111Il0IllIIO0O0lO0I111010IIIII<=IIOlIO1l10OOO1l1IlII1ll0100IOIIIII;IOl00OIO0IOOllO1I1O101lIIl11OIIIII<=IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII;IO0II1lll1llOlO1lll1001O1IlOIOIIII<=IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII;III010I1Ol1OlOI0IO10O0000II11IIIII<=
II01l0llO10l10II111lIlOIllO0lIIIII;IOOO00lOlO0l0llI01lIlOOIIllIlIIIII<=IIO1l1Ol1l11Il0000II00lI011I0IIIII;IIlIIII1lOllO0IlO11I1O01110IOIIIII<=II0l0001lI0I0IlllI1I100OO10IIIIIII;III0lIIOOIOl0ll0ll0l1lO10IlIIIIIII<=IIO0101IlI11I0IOlI01l1ll0O10OIIIII;II0I1I1l00l1O11OOIOIIllII10IlIIIII<=IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII;IO0I10OO0llIIlII1I01OOI001IIIIIIII<=
IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII;III0O000IO1IOIO10l0I00lOIII11IIIII<=IOIIOO1001lI01IOOlOllIOOIO1O1IIIII;II110IlI0l101IO1IlI1O00llI00OIIIII<=IIOlIO1l10OOO1l1IlII1ll0100IOIIIII;IOO000O0Ol1OlIOOI00l11I1l1I00IIIII<=II10l111IOllO0O1111Ill001lll1IIIII;IIll0O11l1O1lOl111IIOlOIl0I0OIIIII<=IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII;IIOI10lI0II00O0IOOl0I10001lO1IIIII
<=IO111Il1I1O0lO1OlOI0l01I1O010IIIII(0);IOO1IIll11IlI110IOlllI1Il1IO1IIIII<=IIl1O01ll1111l0llIOO0OOl1ll0IOIIII;IIl11lIlOO0IIII0IOlI0l1000I1IIIIII<=IIlOllOOI0ll11O1101IIl0l11ll1IIIII(III011IIIl1IO1l0O11000I0llI00IIIII,8);IOOI10l11llO01llIIllOI1IO0l1OIIIII<=IIlOllOOI0ll11O1101IIl0l11ll1IIIII
(II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII,8);II1llIOlOlll00O010O1lI1IOI1I1IIIII<=III11I01Ol11IOO00IOI1I11OOl10IIIII;IO1I11OIllI1III1III11OlIIlIIOIIIII<=IIl1lOIllIlIl01ll00O11OIl100IOIIII;IOIOO101OO01Ol1101l1O01O1OOllIIIII<=IIII00I101O111lII1O000IO1lOOIIIIII;IIOO0IIlO0O0I01l00I1011II0011IIIII<=IOOI01II11O1I1IOII1II01O1001lIIIII;END IF;END
 PROCESS;PUNCTURE_2O:PROCESS(CLK,IIO00Il10lI0OOllOOO0lO11lOOlIOIIII,IOl1I001lIl1Il1I11lI00l11O1OOIIIII,IO0lI0OlO11O10O1III000O01l0l0IIIII,III0l0O0I11OOO1lI0OOIO0llOlIlIIIII,IOO01101I01OlOIO111IIl0OOIOI0IIIII,II00l0IOI1lIlOlOOI0I011O1110OIIIII)TYPE IIlOOO01III1O0O0IOII0I0lOlIlOIIIII IS ARRAY(0 TO C_OUTPUT_RATE-1)OF
 STD_LOGIC_VECTOR(IO0IlO1lI10Il011101l101IIl0IOIIIII-1 DOWNTO 0);TYPE IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII IS ARRAY(0 TO C_OUTPUT_RATE-1)OF STD_LOGIC_VECTOR(IOI1O00I10101l0I1001llOOI0I0IOIIII-1
 DOWNTO 0);VARIABLE IIl010l00OlI0lO1OO11Il10lIOIOOIIII:BOOLEAN:=TRUE;VARIABLE IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII,IIl111Il0IIlOIO000I01l00l0111IIIII,II1111O0III10O0OOlOlOO1l1I1l0IIIII:IIlOOO01III1O0O0IOII0I0lOlIlOIIIII;VARIABLE III00011101l1O1OOI0l0Il0l1l10IIIII:INTEGER;VARIABLE
 IO0lll11llOIOOIOI1lOOIOl000I0IIIII:INTEGER;VARIABLE IO00OO00lIlIO00llOIll10l0ll1OIIIII:STD_LOGIC;VARIABLE IIO1lO000Il1O0lOII1IO0OOOIO00IIIII:STD_LOGIC;VARIABLE II1001l0I11O0IIOIl01I1ll0O0OlIIIII:STD_LOGIC;VARIABLE II1II1OO1ll10IlO0I10O0OI000IIOIIII
:STD_LOGIC;VARIABLE IOOl01OO110II1I0lIlI001II11I0IIIII:STD_LOGIC;VARIABLE II0IIlIOII0IIl1lIO1llO1O1lOlIIIIII:STD_LOGIC;VARIABLE IIll0I0ll1ll1O0IOlO1O01llII00IIIII:STD_LOGIC;VARIABLE II1ll1Il1Il11O10OllIl0l1l1l0IOIIII:
STD_LOGIC;VARIABLE III0II00l1IIlIO100l00OlI1l1O0IIIII:STD_LOGIC;VARIABLE II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:STD_LOGIC;VARIABLE IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII:STD_LOGIC;VARIABLE III101l00lllOOOlIO0OO1lI1OO1OIIIII:
STD_LOGIC;VARIABLE II0l0l0II0Il010II1l000011O1lIIIIII:STD_LOGIC_VECTOR(C_OUTPUT_RATE-1 DOWNTO 0);VARIABLE IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII,IOO0lOOOll1OI0OI0lI10IOOOII00IIIII,II111O1llOOlI0lOOIIIl0OIlIlllIIIII,IIO11lIl110IO0lO00IOOl0Il11I1IIIII:IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII;
CONSTANT II1IO0OO0IOlO11110OOlO1O0101IOIIII:IIIO1O1110Oll10OI110OIIO111OOIIIII:=(C_PUNC_CODE0*(2**C_PUNC_INPUT_RATE)+C_PUNC_CODE0,C_PUNC_CODE1*(2**C_PUNC_INPUT_RATE)+
C_PUNC_CODE1);VARIABLE II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII,IO0OIl1OO10lO00IlIl0Il0l1l1OIIIIII,IO0lllOII000O01100OOI0II1II01IIIII:STD_LOGIC;VARIABLE IO0IllIIO11IlI1010IIl0l000001IIIII:STD_LOGIC;BEGIN IF(C_PUNCTURED=1 AND
 C_DUAL_CHANNEL=1)THEN IF(IIl010l00OlI0lO1OO11Il10lIOIOOIIII)THEN IIl010l00OlI0lO1OO11Il10lIOIOOIIII:=FALSE;FOR II1l0I0l10l0I1I1lO01l10I01lI1IIIII IN 0 TO C_OUTPUT_RATE-1 LOOP IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII(II1l0I0l10l0I1I1lO01l10I01lI1IIIII):=(OTHERS=>'0');IIl111Il0IIlOIO000I01l00l0111IIIII(II1l0I0l10l0I1I1lO01l10I01lI1IIIII):=(
OTHERS=>'0');II1111O0III10O0OOlOlOO1l1I1l0IIIII(II1l0I0l10l0I1I1lO01l10I01lI1IIIII):=(OTHERS=>'0');END LOOP;III00011101l1O1OOI0l0Il0l1l10IIIII:=0;IO0lll11llOIOOIOI1lOOIOl000I0IIIII:=0;II1001l0I11O0IIOIl01I1ll0O0OlIIIII:='0';II1II1OO1ll10IlO0I10O0OI000IIOIIII:='0';IIO1lO000Il1O0lOII1IO0OOOIO00IIIII:='0';
IO00OO00lIlIO00llOIll10l0ll1OIIIII:='0';IIll0I0ll1ll1O0IOlO1O01llII00IIIII:='0';II1ll1Il1Il11O10OllIl0l1l1l0IOIIII:='0';III0II00l1IIlIO100l00OlI1l1O0IIIII:='0';II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:='1';IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII:='0';III101l00lllOOOlIO0OO1lI1OO1OIIIII:='0';IOOl01OO110II1I0lIlI001II11I0IIIII
:='0';II0IIlIOII0IIl1lIO1llO1O1lOlIIIIII:='0';FOR IIO001lIl0II1lI10I1000O00Ol10IIIII IN 0 TO C_OUTPUT_RATE-1 LOOP IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII(IIO001lIl0II1lI10I1000O00Ol10IIIII):=(OTHERS=>'0');IOO0lOOOll1OI0OI0lI10IOOOII00IIIII(IIO001lIl0II1lI10I1000O00Ol10IIIII):=(OTHERS=>'0');II111O1llOOlI0lOOIIIl0OIlIlllIIIII(IIO001lIl0II1lI10I1000O00Ol10IIIII)
:=(OTHERS=>'0');II0l0l0II0Il010II1l000011O1lIIIIII(IIO001lIl0II1lI10I1000O00Ol10IIIII):='0';END LOOP;II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII:='0';IO0IllIIO11IlI1010IIl0l000001IIIII:='0';IO0OIl1OO10lO00IlIl0Il0l1l1OIIIIII:='0';END IF;FOR IIOI1lO0I00III00II0IO0ll0111IOIIII IN 0 TO C_OUTPUT_RATE-1 LOOP
 FOR III11OII1IlIl1001I1IO1111l0IlIIIII IN 0 TO IOI1O00I10101l0I1001llOOI0I0IOIIII-1 LOOP IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII(IIOI1lO0I00III00II0IO0ll0111IOIIII)(III11OII1IlIl1001I1IO1111l0IlIIIII):=II1111O0III10O0OOlOlOO1l1I1l0IIIII(III1O0Ol0IOOO0IllIOOO000O1lO0IIIII(IIOI1lO0I00III00II0IO0ll0111IOIIII,III11OII1IlIl1001I1IO1111l0IlIIIII,II1IO0OO0IOlO11110OOlO1O0101IOIIII,C_OUTPUT_RATE,
IOI1O00I10101l0I1001llOOI0I0IOIIII))(IIIIl0I1lO1llIOIOOO1lOl11IIlOIIIII(IIOI1lO0I00III00II0IO0ll0111IOIIII,III11OII1IlIl1001I1IO1111l0IlIIIII,II1IO0OO0IOlO11110OOlO1O0101IOIIII,C_OUTPUT_RATE,IOI1O00I10101l0I1001llOOI0I0IOIIII));END LOOP;END LOOP;FOR IIII11lI1lOl0OlOO0II11lI101lOIIIII IN 0 TO
 C_OUTPUT_RATE-1 LOOP IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII(IIII11lI1lOl0OlOO0II11lI101lOIIIII)(IO0IlO1lI10Il011101l101IIl0IOIIIII-1 DOWNTO 1):=IIl111Il0IIlOIO000I01l00l0111IIIII(IIII11lI1lOl0OlOO0II11lI101lOIIIII)(IO0IlO1lI10Il011101l101IIl0IOIIIII-2 DOWNTO 0);IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII(IIII11lI1lOl0OlOO0II11lI101lOIIIII)(0):=IIO00Il10lI0OOllOOO0lO11lOOlIOIIII(IIII11lI1lOl0OlOO0II11lI101lOIIIII);
END LOOP;IF(IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1')THEN IOOl01OO110II1I0lIlI001II11I0IIIII:='1';ELSE IOOl01OO110II1I0lIlI001II11I0IIIII:='0';END IF;IF(IOO01101I01OlOIO111IIl0OOIOI0IIIII='1')THEN FOR IOl0Ill1OOl0O1IO1l0010I0lO010IIIII IN 0 TO C_OUTPUT_RATE-1 LOOP IIl111Il0IIlOIO000I01l00l0111IIIII(IOl0Ill1OOl0O1IO1l0010I0lO010IIIII
):=(OTHERS=>'0');II1111O0III10O0OOlOlOO1l1I1l0IIIII(IOl0Ill1OOl0O1IO1l0010I0lO010IIIII):=(OTHERS=>'0');END LOOP;III00011101l1O1OOI0l0Il0l1l10IIIII:=0;IO0lll11llOIOOIOI1lOOIOl000I0IIIII:=0;II1001l0I11O0IIOIl01I1ll0O0OlIIIII:='0';II1II1OO1ll10IlO0I10O0OI000IIOIIII:='0';IO00OO00lIlIO00llOIll10l0ll1OIIIII:='0';
IIO1lO000Il1O0lOII1IO0OOOIO00IIIII:='0';II1II1OO1ll10IlO0I10O0OI000IIOIIII:='0';IIll0I0ll1ll1O0IOlO1O01llII00IIIII:='0';IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII:='0';III101l00lllOOOlIO0OO1lI1OO1OIIIII:='0';II1ll1Il1Il11O10OllIl0l1l1l0IOIIII:='0';III0II00l1IIlIO100l00OlI1l1O0IIIII:='0';
II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:='1';IOOl01OO110II1I0lIlI001II11I0IIIII:='0';II0IIlIOII0IIl1lIO1llO1O1lOlIIIIII:='0';FOR IO0IlOI1OIOO0l101l10IO00l0101IIIII IN 0 TO C_OUTPUT_RATE-1 LOOP II111O1llOOlI0lOOIIIl0OIlIlllIIIII(IO0IlOI1OIOO0l101l10IO00l0101IIIII):=(OTHERS=>'0');IOO0lOOOll1OI0OI0lI10IOOOII00IIIII(IO0IlOI1OIOO0l101l10IO00l0101IIIII)(
IOI1O00I10101l0I1001llOOI0I0IOIIII-2 DOWNTO 0):=II111O1llOOlI0lOOIIIl0OIlIlllIIIII(IO0IlOI1OIOO0l101l10IO00l0101IIIII)(IOI1O00I10101l0I1001llOOI0I0IOIIII-1 DOWNTO 1);IOO0lOOOll1OI0OI0lI10IOOOII00IIIII(IO0IlOI1OIOO0l101l10IO00l0101IIIII)(IOI1O00I10101l0I1001llOOI0I0IOIIII-1):='0';II0l0l0II0Il010II1l000011O1lIIIIII(IO0IlOI1OIOO0l101l10IO00l0101IIIII):='0';END
 LOOP;II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII:='0';IO0OIl1OO10lO00IlIl0Il0l1l1OIIIIII:='0';IO0IllIIO11IlI1010IIl0l000001IIIII:='0';ELSIF(CLK'event AND CLK='1'AND II00l0IOI1lIlOlOOI0I011O1110OIIIII='0'AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='1')THEN IIO1lO000Il1O0lOII1IO0OOOIO00IIIII:=
IO00OO00lIlIO00llOIll10l0ll1OIIIII;IF((IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1'AND IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII='0')OR(IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1'AND IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1'))THEN III101l00lllOOOlIO0OO1lI1OO1OIIIII:='1';ELSE III101l00lllOOOlIO0OO1lI1OO1OIIIII:='0';END IF;IF(
IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1'AND IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII='0')THEN IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII:='1';END IF;IF(II1II1OO1ll10IlO0I10O0OI000IIOIIII='1')THEN II1111O0III10O0OOlOlOO1l1I1l0IIIII:=IIl111Il0IIlOIO000I01l00l0111IIIII;END IF;IF(II1II1OO1ll10IlO0I10O0OI000IIOIIII='1')THEN
 II111O1llOOlI0lOOIIIl0OIlIlllIIIII:=IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII;ELSE II111O1llOOlI0lOOIIIl0OIlIlllIIIII:=IOO0lOOOll1OI0OI0lI10IOOOII00IIIII;END IF;FOR IIOO1OlIO01I00l0OO0I11OII1OlOIIIII IN 0 TO C_OUTPUT_RATE-1 LOOP II0l0l0II0Il010II1l000011O1lIIIIII(IIOO1OlIO01I00l0OO0I11OII1OlOIIIII):=II111O1llOOlI0lOOIIIl0OIlIlllIIIII(IIOO1OlIO01I00l0OO0I11OII1OlOIIIII)(0);END LOOP
;IF(C_HAS_RDY=1)THEN IO0IllIIO11IlI1010IIl0l000001IIIII:=(II1II1OO1ll10IlO0I10O0OI000IIOIIII OR IO0IllIIO11IlI1010IIl0l000001IIIII)AND NOT(II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII AND NOT II1II1OO1ll10IlO0I10O0OI000IIOIIII);IO0lll11llOIOOIOI1lOOIOl000I0IIIII:=IO0lll11llOIOOIOI1lOOIOl000I0IIIII+1;IF(
IO0lll11llOIOOIOI1lOOIOl000I0IIIII=IOI1O00I10101l0I1001llOOI0I0IOIIII-1)THEN II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII:='1';ELSE II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII:='0';END IF;IF(II1II1OO1ll10IlO0I10O0OI000IIOIIII='1')THEN
 II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII:='0';IO0lll11llOIOOIOI1lOOIOl000I0IIIII:=0;END IF;IF(IO0lll11llOIOOIOI1lOOIOl000I0IIIII=IOI1O00I10101l0I1001llOOI0I0IOIIII)THEN IO0lll11llOIOOIOI1lOOIOl000I0IIIII:=0;END IF;END IF;FOR IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII IN 0 TO
 C_OUTPUT_RATE-1 LOOP IOO0lOOOll1OI0OI0lI10IOOOII00IIIII(IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII)(IOI1O00I10101l0I1001llOOI0I0IOIIII-2 DOWNTO 0):=II111O1llOOlI0lOOIIIl0OIlIlllIIIII(IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII)(IOI1O00I10101l0I1001llOOI0I0IOIIII-1 DOWNTO 1);IOO0lOOOll1OI0OI0lI10IOOOII00IIIII(IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII)(
IOI1O00I10101l0I1001llOOI0I0IOIIII-1):='0';END LOOP;IF(II0IIlIOII0IIl1lIO1llO1O1lOlIIIIII='1'OR(IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII='1'AND IOl1I001lIl1Il1I11lI00l11O1OOIIIII='1'))THEN IIl111Il0IIlOIO000I01l00l0111IIIII:=IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII;END IF;IF(IO0lI0OlO11O10O1III000O01l0l0IIIII='1')THEN
 III00011101l1O1OOI0l0Il0l1l10IIIII:=III00011101l1O1OOI0l0Il0l1l10IIIII+1;IF(III101l00lllOOOlIO0OO1lI1OO1OIIIII='1')THEN III00011101l1O1OOI0l0Il0l1l10IIIII:=0;END IF;IF(III00011101l1O1OOI0l0Il0l1l10IIIII=IO0IlO1lI10Il011101l101IIl0IOIIIII-1)THEN IO00OO00lIlIO00llOIll10l0ll1OIIIII:='1';ELSE
 IO00OO00lIlIO00llOIll10l0ll1OIIIII:='0';END IF;IF(III00011101l1O1OOI0l0Il0l1l10IIIII=IO0IlO1lI10Il011101l101IIl0IOIIIII)THEN III00011101l1O1OOI0l0Il0l1l10IIIII:=0;END IF;END IF;II1ll1Il1Il11O10OllIl0l1l1l0IOIIII:=IO0lI0OlO11O10O1III000O01l0l0IIIII OR IOl1I001lIl1Il1I11lI00l11O1OOIIIII OR II1ll1Il1Il11O10OllIl0l1l1l0IOIIII;
II1II1OO1ll10IlO0I10O0OI000IIOIIII:=II1001l0I11O0IIOIl01I1ll0O0OlIIIII;II1001l0I11O0IIOIl01I1ll0O0OlIIIII:=IO00OO00lIlIO00llOIll10l0ll1OIIIII AND NOT IIO1lO000Il1O0lOII1IO0OOOIO00IIIII;II0IIlIOII0IIl1lIO1llO1O1lOlIIIIII:=IOOl01OO110II1I0lIlI001II11I0IIIII;IF C_HAS_RFFD/=0 AND C_HAS_FD/=0 THEN
 II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:=II1001l0I11O0IIOIl01I1ll0O0OlIIIII OR(NOT II1ll1Il1Il11O10OllIl0l1l1l0IOIIII);END IF;IF C_HAS_RFFD/=0 AND C_HAS_FD=0 THEN II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:='1';END IF;ELSIF(CLK'event AND CLK
='1'AND II00l0IOI1lIlOlOOI0I011O1110OIIIII='1')THEN IF III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='1'THEN IO0IllIIO11IlI1010IIl0l000001IIIII:='0';IO0OIl1OO10lO00IlIl0Il0l1l1OIIIIII:='0';II1001l0I11O0IIOIl01I1ll0O0OlIIIII:='0';II1II1OO1ll10IlO0I10O0OI000IIOIIII:='0';IO00OO00lIlIO00llOIll10l0ll1OIIIII:='0';IIO1lO000Il1O0lOII1IO0OOOIO00IIIII:=
'0';II1II1OO1ll10IlO0I10O0OI000IIOIIII:='0';IIll0I0ll1ll1O0IOlO1O01llII00IIIII:='0';II1ll1Il1Il11O10OllIl0l1l1l0IOIIII:='0';III0II00l1IIlIO100l00OlI1l1O0IIIII:='0';II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:='1';IO0lll11llOIOOIOI1lOOIOl000I0IIIII:=0;III00011101l1O1OOI0l0Il0l1l10IIIII:=0;
II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII:='0';IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII:='0';III101l00lllOOOlIO0OO1lI1OO1OIIIII:='0';IOOl01OO110II1I0lIlI001II11I0IIIII:='0';II0IIlIOII0IIl1lIO1llO1O1lOlIIIIII:='0';FOR IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII IN 0 TO C_OUTPUT_RATE-1 LOOP
 IIl111Il0IIlOIO000I01l00l0111IIIII(IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII):=(OTHERS=>'0');II1111O0III10O0OOlOlOO1l1I1l0IIIII(IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII):=(OTHERS=>'0');END LOOP;FOR IIl1O1IllII0I01IlO01l0lII0lIOOIIII IN 0 TO C_OUTPUT_RATE-1 LOOP II111O1llOOlI0lOOIIIl0OIlIlllIIIII(IIl1O1IllII0I01IlO01l0lII0lIOOIIII):=(OTHERS=>'0');
IOO0lOOOll1OI0OI0lI10IOOOII00IIIII(IIl1O1IllII0I01IlO01l0lII0lIOOIIII)(IOI1O00I10101l0I1001llOOI0I0IOIIII-2 DOWNTO 0):=II111O1llOOlI0lOOIIIl0OIlIlllIIIII(IIl1O1IllII0I01IlO01l0lII0lIOOIIII)(IOI1O00I10101l0I1001llOOI0I0IOIIII-1 DOWNTO 1);IOO0lOOOll1OI0OI0lI10IOOOII00IIIII(IIl1O1IllII0I01IlO01l0lII0lIOOIIII)(IOI1O00I10101l0I1001llOOI0I0IOIIII-1):='0';
II0l0l0II0Il010II1l000011O1lIIIIII(IIl1O1IllII0I01IlO01l0lII0lIOOIIII):='0';END LOOP;END IF;END IF;IIOIlOO1lI01O10O1Ol0OOI10110OIIIII<=II0l0l0II0Il010II1l000011O1lIIIIII;IOO0llOIlIO0110l1lOO01I00l1OIIIIII<=IO0IllIIO11IlI1010IIl0l000001IIIII;IOO0IOIOOll0Il0OlI001lIIIOOOIIIIII<=II11OIIIO0I0OI0IIIIO1lOO011IlIIIII;END IF;END PROCESS;CONV_SYNC
:PROCESS(CLK,III0l0O0I11OOO1lI0OOIO0llOlIlIIIII,IOO01101I01OlOIO111IIl0OOIOI0IIIII,II00l0IOI1lIlOlOOI0I011O1110OIIIII,IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII,IOl1I001lIl1Il1I11lI00l11O1OOIIIII)VARIABLE IOI1IOl0OI0O1OllO10lO1lOOl0l1IIIII:BOOLEAN:=TRUE;VARIABLE IIII00IOl0llO0O011llO1lOOOIIOIIIII,IIlOIl110lOl10lO1OIllII10IOO1IIIII,IO0O00IOlOOIOO11lI01l000IIIIOIIIII,II10I1011llOIIlI00OI0IIIl0OIOIIIII:STD_LOGIC;VARIABLE
 IOI0O1l0101lI100OIOIlll001OO1IIIII:STD_LOGIC;CONSTANT IIlI1lIIIOI0l01l01OOII00I0O0lIIIII:INTEGER:=1;VARIABLE IO1lII1OIl0llIl0IIlIlOI10l0OlIIIII:INTEGER:=0;VARIABLE IIl000O0IO0llO0II1lI1010lOO0IOIIII:INTEGER:=0;VARIABLE IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII:STD_LOGIC
;VARIABLE IOlIll0lIIOlIl1l1lI01OII11lOIIIIII:STD_LOGIC;VARIABLE II1OO01O01O10l0IIOIII101O1000IIIII,II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII:STD_LOGIC;VARIABLE II0I00l0IOOO11I1l0O11O1I1O101IIIII,IOlO0lIIlI010OIO10l11l1l1lIO0IIIII:STD_LOGIC;VARIABLE II10010II0ll0l10O0OOI01I11110IIIII:INTEGER:=0;BEGIN IF
(IOI1IOl0OI0O1OllO10lO1lOOl0l1IIIII)THEN IOI1IOl0OI0O1OllO10lO1lOOl0l1IIIII:=FALSE;II10I1011llOIIlI00OI0IIIl0OIOIIIII:='0';IIII00IOl0llO0O011llO1lOOOIIOIIIII:='0';IIlOIl110lOl10lO1OIllII10IOO1IIIII:='0';IO0O00IOlOOIOO11lI01l000IIIIOIIIII:='0';IOI0O1l0101lI100OIOIlll001OO1IIIII:='0';IIl000O0IO0llO0II1lI1010lOO0IOIIII:=0;IO1lII1OIl0llIl0IIlIlOI10l0OlIIIII:=0;II1OO01O01O10l0IIOIII101O1000IIIII:='0';
II0I00l0IOOO11I1l0O11O1I1O101IIIII:='0';IOlO0lIIlI010OIO10l11l1l1lIO0IIIII:='0';II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII:='0';II10010II0ll0l10O0OOI01I11110IIIII:=0;IOlIll0lIIOlIl1l1lI01OII11lOIIIIII:='0';IF(C_PUNCTURED=0)THEN IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII:='0';END IF;END IF;IF(C_PUNCTURED=0)THEN
 IIO0101IlI11I0IOlI01l1ll0O10OIIIII<='1';IO0lI0OlO11O10O1III000O01l0l0IIIII<=IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII;IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII<='1';IF(C_HAS_RDY/=0)THEN IF(IOO01101I01OlOIO111IIl0OOIOI0IIIII='1')THEN IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII:='0';IOlIll0lIIOlIl1l1lI01OII11lOIIIIII:='0';ELSIF(CLK'event AND
 CLK='1'AND II00l0IOI1lIlOlOOI0I011O1110OIIIII='0'AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='1')THEN IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII:=IOlIll0lIIOlIl1l1lI01OII11lOIIIIII;IOlIll0lIIOlIl1l1lI01OII11lOIIIIII:=IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII;ELSIF(CLK'event AND CLK='1'AND II00l0IOI1lIlOlOOI0I011O1110OIIIII='1'AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='1')THEN
 IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII:='0';IOlIll0lIIOlIl1l1lI01OII11lOIIIIII:='0';END IF;END IF;IO00OI0ll1l1l0llI1I000OOO0010IIIII<=IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII;END IF;IF(C_PUNCTURED=1 AND C_DUAL_CHANNEL=0)THEN IF(IOO01101I01OlOIO111IIl0OOIOI0IIIII='1')THEN II10I1011llOIIlI00OI0IIIl0OIOIIIII:=
'0';II10010II0ll0l10O0OOI01I11110IIIII:=0;IO0O00IOlOOIOO11lI01l000IIIIOIIIII:='0';ELSIF(CLK'event AND CLK='1'AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII='1')THEN IF(II00l0IOI1lIlOlOOI0I011O1110OIIIII='0')THEN II10I1011llOIIlI00OI0IIIl0OIOIIIII:=IO0O00IOlOOIOO11lI01l000IIIIOIIIII;IF(II1OO01O01O10l0IIOIII101O1000IIIII='1')THEN
 II10010II0ll0l10O0OOI01I11110IIIII:=II10010II0ll0l10O0OOI01I11110IIIII+1;IF(II10010II0ll0l10O0OOI01I11110IIIII=C_PUNC_INPUT_RATE)THEN IO0O00IOlOOIOO11lI01l000IIIIOIIIII:='1';ELSE IO0O00IOlOOIOO11lI01l000IIIIOIIIII:='0';END IF;IF(II10010II0ll0l10O0OOI01I11110IIIII=C_PUNC_INPUT_RATE+1)
THEN II10010II0ll0l10O0OOI01I11110IIIII:=0;END IF;IF(IOlO0lIIlI010OIO10l11l1l1lIO0IIIII='1')THEN IO0O00IOlOOIOO11lI01l000IIIIOIIIII:='0';II10010II0ll0l10O0OOI01I11110IIIII:=0;END IF;END IF;ELSE II10I1011llOIIlI00OI0IIIl0OIOIIIII:='0';II10010II0ll0l10O0OOI01I11110IIIII:=0;IO0O00IOlOOIOO11lI01l000IIIIOIIIII:='0';END
 IF;END IF;II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII:=NOT(IO0O00IOlOOIOO11lI01l000IIIIOIIIII AND NOT(II10I1011llOIIlI00OI0IIIl0OIOIIIII));II1OO01O01O10l0IIOIII101O1000IIIII:=II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII AND IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII;IOlO0lIIlI010OIO10l11l1l1lIO0IIIII:=IOl1I001lIl1Il1I11lI00l11O1OOIIIII AND II1OO01O01O10l0IIOIII101O1000IIIII;IIII00IOl0llO0O011llO1lOOOIIOIIIII:=II1OO01O01O10l0IIOIII101O1000IIIII AND III0l0O0I11OOO1lI0OOIO0llOlIlIIIII
;II0I00l0IOOO11I1l0O11O1I1O101IIIII:=II00l0IOI1lIlOlOOI0I011O1110OIIIII OR IOlO0lIIlI010OIO10l11l1l1lIO0IIIII;IIO1O00llO01OII1I11lIIO001lI0IIIII<=IOlO0lIIlI010OIO10l11l1l1lIO0IIIII;IO0lI0OlO11O10O1III000O01l0l0IIIII<=II1OO01O01O10l0IIOIII101O1000IIIII;END IF;IF(C_PUNCTURED=1 AND C_DUAL_CHANNEL=1)THEN IO0lI0OlO11O10O1III000O01l0l0IIIII<=IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII;END IF
;END PROCESS;NOT_PUNC:IF(C_PUNCTURED=0)GENERATE DATA_OUT_V<=IOIO1OI0IlI1I1010lO000IO01Ol0IIIII AFTER IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;DATA_OUT_S<='X';END GENERATE;PUNC:IF(
C_PUNCTURED=1 AND C_DUAL_CHANNEL=0)GENERATE IIO00Il10lI0OOllOOO0lO11lOOlIOIIII<=IIIIOOlIIO11011I1IlOO10OOOO0OIIIII AFTER IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;DATA_OUT_S<=IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII AFTER IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;NPL
:FOR IIllIl0lIO10011Ol0O10l01O1Il0IIIII IN 0 TO C_OUTPUT_RATE-1 GENERATE DATA_OUT_V(IIllIl0lIO10011Ol0O10l01O1Il0IIIII)<='X';END GENERATE;END GENERATE;PUNC_DO:IF(C_PUNCTURED=1)AND(C_DUAL_CHANNEL=1)
GENERATE IIO00Il10lI0OOllOOO0lO11lOOlIOIIII<=IIIIOOlIIO11011I1IlOO10OOOO0OIIIII AFTER IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;DATA_OUT_V<=IIOIlOO1lI01O10O1Ol0OOI10110OIIIII AFTER IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;DATA_OUT_S<='X';END GENERATE;RFD_O
:IF(C_HAS_RFD=1)GENERATE PUNC_SERIAL_RFD:IF((C_PUNCTURED=1)AND(C_DUAL_CHANNEL=0))GENERATE IOl1100I00OlIllOI1I0III1O1l01IIIII<=IOl00OIO0IOOllO1I1O101lIIl11OIIIII AFTER IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;RFD<=
IOl1100I00OlIllOI1I0III1O1l01IIIII;END GENERATE;PUNC_DUAL_RFD:IF((C_PUNCTURED=1)AND(C_DUAL_CHANNEL/=0))GENERATE IOl1100I00OlIllOI1I0III1O1l01IIIII<=IIO0101IlI11I0IOlI01l1ll0O10OIIIII AFTER IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;RFD<=IOl1100I00OlIllOI1I0III1O1l01IIIII;END
 GENERATE;NP_RFD:IF(C_PUNCTURED=0)GENERATE IOl1100I00OlIllOI1I0III1O1l01IIIII<=IIO0101IlI11I0IOlI01l1ll0O10OIIIII AFTER IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;RFD<=IOl1100I00OlIllOI1I0III1O1l01IIIII;END GENERATE;END GENERATE;RFD_O0:IF(C_HAS_RFD
=0)GENERATE IOl1100I00OlIllOI1I0III1O1l01IIIII<='1';RFD<='X';END GENERATE;RFFD_O:IF(C_HAS_RFFD/=0)GENERATE RFFD_NOTP:IF(C_PUNCTURED=0)GENERATE IOIl1lI1IO111IO0OII101O1I0l0IOIIII<=IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII
 AFTER IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;RFFD<=IOIl1lI1IO111IO0OII101O1I0l0IOIIII;END GENERATE;RFFD_PUNC:IF(C_PUNCTURED/=0)GENERATE DP:IF C_DUAL_CHANNEL/=0 GENERATE IOIl1lI1IO111IO0OII101O1I0l0IOIIII<=IOO0IOIOOll0Il0OlI001lIIIOOOIIIIII
 AFTER IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;RFFD<=IOIl1lI1IO111IO0OII101O1I0l0IOIIII;END GENERATE;SP:IF C_DUAL_CHANNEL=0 GENERATE IOIl1lI1IO111IO0OII101O1I0l0IOIIII<=IOI0111Il0IllIIO0O0lO0I111010IIIII AFTER IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;RFFD<=IOIl1lI1IO111IO0OII101O1I0l0IOIIII;END
 GENERATE;END GENERATE;END GENERATE;RFFD_O0:IF(C_HAS_RFFD=0)GENERATE IOIl1lI1IO111IO0OII101O1I0l0IOIIII<='1';RFFD<='X';END GENERATE;RDY_O:IF(C_HAS_RDY/=0)
GENERATE NP_RDY:IF(C_PUNCTURED=0)GENERATE RDY<=IO00OI0ll1l1l0llI1I000OOO0010IIIII AFTER IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;END GENERATE;P_RDY:IF(C_PUNCTURED/=0 AND C_DUAL_CHANNEL=0)
GENERATE RDY<=IOl0OIIOl0O00OO0lI0I0O1IO1OOIOIIII AFTER IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;END GENERATE;DP_RDY:IF(C_PUNCTURED/=0 AND C_DUAL_CHANNEL/=0)GENERATE RDY<=IOO0llOIlIO0110l1lOO01I00l1OIIIIII AFTER IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;
END GENERATE;END GENERATE;RDY_O0:IF(C_HAS_RDY=0)GENERATE NP_RDY:IF(C_PUNCTURED=0)GENERATE IO00OI0ll1l1l0llI1I000OOO0010IIIII<='1';END GENERATE;RDY<='X';END
 GENERATE;IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII<=IO0lI0OlO11O10O1III000O01l0l0IIIII AFTER IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;IO01O100lOO0IOOI000OO1lIOO1l0IIIII<=IIO1O00llO01OII1I11lIIO001lI0IIIII AFTER IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;END;
